% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptHoldoutSize_estimation.R
\name{powersolve_general}
\alias{powersolve_general}
\title{General solver for power law curve}
\usage{
powersolve_general(x, y, y_var = rep(1, length(x)), ...)
}
\arguments{
\item{x}{X values}

\item{y}{Y values}

\item{y_var}{Optional parameter giving sampling variance of each y value. Defaults to 1.}

\item{...}{further parameters passed to optim. We suggest specifying lower and upper bounds for (a,b,c); e.g. lower=c(1,0,0),upper=c(10000,3,1)}
}
\value{
List (output from \code{optim}) containing MLE values of (a,b,c)
}
\description{
Find least-squares solution: MLE of (a,b,c) under model
\verb{y_i = a x_i^-b + c + e_i};
\code{e_i~N(0,y_var_i)}

Try a range of starting values and refine estimate.

Slower than a single call to \code{powersolve()}
}
\examples{

# Retrieval of original values
A_true=2000; B_true=1.5; C_true=0.3; sigma=0.002

X=1000*abs(rnorm(10000,mean=4))
Y=A_true*(X^(-B_true)) + C_true + rnorm(length(X),sd=sigma)

c(A_true,B_true,C_true)
powersolve_general(X[1:10],Y[1:10])$par
powersolve_general(X[1:100],Y[1:100])$par
powersolve_general(X[1:1000],Y[1:1000])$par
}
\keyword{aspre}
\keyword{estimation}
