% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumhazard.R
\name{cumhazard}
\alias{cumhazard}
\title{Get Cumulative Hazard at a Landmark Timepoint}
\usage{
cumhazard(
  eventRates = tibble::tibble(duration = c(3, 100), rate = c(log(2)/5, log(2)/5 * 0.5)),
  landmark
)
}
\arguments{
\item{eventRates}{A tibble containing period duration (\code{duration}) and event rate (\code{rate})
for specified periods.}

\item{landmark}{The landmark of interest to evaluate cumulative hazard.}
}
\value{
A numeric which is the cumulative hazard at a landmark timepoint.
}
\description{
Get Cumulative Hazard at a Landmark Timepoint
}
\examples{
# Piecewise exponential event rates of 0.5 for time 0-3, 0.4 for time 3-6, and 0.5 after
cumhaz <- cumhazard(eventRates=tibble::tibble(duration = c(3,3,100),rate = c(0.5, 0.4, 0.3)),
                    landmark=12)

}
