% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculator.R
\name{calculator}
\alias{calculator}
\title{calculator of Pvalue}
\usage{
calculator(survival, RNA, result)
}
\arguments{
\item{survival}{the dataframe that contains survival data}

\item{RNA}{the dataframe that contains the expression data of genes}

\item{result}{the dataframe which will contains the outcome}
}
\value{
this function will return a dataframe that contains either the gene's ensemble IDs and it's Pvalue.
}
\description{
By using this function, you can calculate the Pvalue of all genes you have provided.
}
\examples{
library(Oncofilterfast)
result <- data.frame(gene = c("A"),Pvalue = c(1))
RNA_all_path=system.file("extdata", "TCGA-LGG.htseq_fpkm.tsv", package = "Oncofilterfast")
RNA_all=read.csv(RNA_all_path,header=TRUE,sep="\t")
rows_to_keep <- apply(RNA_all[, -1], 1, function(row) {
  non_zero_count <- sum(row != 0)
  total_elements <- length(row)
  (non_zero_count / total_elements) >= 0.5
  })
RNA <- RNA_all[rows_to_keep, ]
survival_path=system.file("extdata", "TCGA-LGG.survival.tsv", package = "Oncofilterfast")
survival=read.csv(survival_path,header=TRUE,sep="\t")
final=calculator(survival=survival,RNA=RNA,result=result)
print(nrow(final))
filtered_result <- final[final$Pvalue < 0.01, ]
print(nrow(filtered_result))
print(filtered_result)

}
