% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist2eu.R
\name{dist2eu}
\alias{dist2eu}
\title{Euclidean Distance}
\usage{
dist2eu(X,C)
}
\arguments{
\item{X}{The first samples matrix}

\item{C}{The second samples matrix}
}
\value{
The distance matrix
}
\description{
The distance matrix of the two group of samples
}
\examples{

data1 <- matrix(0,100,100)
data2 <- matrix(0,80,100)
for (i in 1:20)
{
  data1[i,] <- rnorm(100,10,1)
}
for (i in 21:40)
{
  data1[i,] <- rnorm(100,20,1)
}
for (i in 41:60)
{
  data1[i,] <- rnorm(100,30,1)
}
for (i in 61:80)
{
  data1[i,] <- rnorm(100,40,1)
}
for (i in 81:100)
{
  data1[i,] <- rnorm(100,50,1)
}
for (i in 1:20)
{
  data2[i,] <- rnorm(100,5,1)
}
for (i in 21:40)
{
  data2[i,] <- rnorm(100,10,1)
}
for (i in 41:60)
{
  data2[i,] <- rnorm(100,15,1)
}
for (i in 61:80)
{
  data2[i,] <- rnorm(100,20,1)
}
new_data1 <- Standard_Normalization(data1)
new_data2 <- Standard_Normalization(data2)
dist1 <- dist2eu(new_data1,new_data2)
}
\author{
Xiaoyao Yin
}
