% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_values_start_end.R
\name{extract_values_start_end}
\alias{extract_values_start_end}
\title{Extract values from start or end patterns}
\usage{
extract_values_start_end(list_input, lines, pattern)
}
\arguments{
\item{list_input}{List. The list to append extracted values to.}

\item{lines}{Character vector. The text lines to search within.}

\item{pattern}{Character. The pattern to search for.}
}
\value{
An updated list with appended values.
}
\description{
This function appends extracted variable values based on start or end markers to a list.
}
\examples{
InputPath <- system.file("extdata", package = "ORscraper")
files <- read_pdf_files(InputPath)
lines <- read_pdf_content(files[1])  # Example with the first file
diagnostic <- gender <- tumor_cell_percentage <- quality <- c()
diagnostic <- extract_values_start_end(diagnostic, lines, ".*Diagnóstico:\\\\s")
gender <- extract_values_start_end(gender, lines, ".*Sexo:\\\\s*")
tumor_cell_percentage <- extract_values_start_end(
                                tumor_cell_percentage,
                                lines,
                                ".*\% células tumorales:\\\\s")
quality <- extract_values_start_end(
                                quality,
                                lines,
                                ".*CALIDAD DE LA MUESTRA /LIMITACIONES PARA SU ANÁLISIS:\\\\s")
}
