
# Module: VecMardia
#
# Generates a vector of pairwise marginal means given marginal means and marginal Odds Ratio (OR)
#
# Note: for more information, see Mardia (1967)
#
# @param muj is a vector generated by \code{Star} function
# @param muk is a vector generated by \code{DStar} function
# @param gamma is the \code{log}(OR) between outcome j and k for cluster i
#
# @return a vector of pairwise marginal means



VecMardia<-function(muk,muj,gamma){
  psi<-exp(gamma)
  a<-muj+muk
  b<-ifelse(psi==1,0.0001,(psi-1))
  c<-1+a*b
  d<-c-sqrt(c*c-4*psi*b*muj*muk)
  e<-ifelse(psi==1,muj*muk,0.5*d/b)
  return(e)
}
