% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NostalgiR.R
\name{nos.qqnorm}
\alias{nos.qqnorm}
\title{nos.qqnorm text-based normal quantile-quantile plots}
\usage{
nos.qqnorm(data, line = T, ratio = 0.25, width = round(options()$width *
  0.8), height = round(ratio * width), pch = c("o", "~"))
}
\arguments{
\item{data}{A numeric vector containing the values to be plotted. \code{NA} and \code{NaN} are allowed, but are removed for the plot. Infinities will cause an error.}

\item{line}{If \code{TRUE}, the line of theoretical quantile equality is plotted. If \code{FALSE}, then the line of theoretical quantile equality is not plotted.}

\item{ratio}{Coefficient that controls the aspect ratio of the plot.}

\item{width}{Width of the plot in points.}

\item{height}{Height of the plot in points.}

\item{pch}{A two dimensional vector of single-character symbols. The first symbol is for data point, and the second symbol is for the line of theoretical quantile equality.}
}
\description{
Produces a text-based normal quantile-quantile plot where the theoretical quantiles are plotted along the x-axis and the sample quantiles are plotted along the y-axis.
}
\note{
Due to rounding to a relatively crude grid results can only be approximate. The equally spaced axis ticks, for example, may be non-equally spaced in the plot. Further, due to the crude grid also there might be several points per character. The function uses the same plotting symbol no matter how many points coincide on one character position.
}
\examples{
## Produce a normal quantile-quantile plot of 10 random standard normal points,
## without the line of theoretical quantile equality.
data <- rnorm(10)
nos.qqnorm(data,line=FALSE)

## Produce a normal quantile-quantile plot of 100 random chi-squared(3) points,
## with the line of theoretical quantile equality.
data <- rchisq(100,3)
nos.qqnorm(data)
}
\author{
Hien D. Nguyen
}
\seealso{
\code{\link[stats]{qqnorm}}, \code{\link[stats]{qqline}} and \code{\link[txtplot]{txtplot}}.
}

