% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{vd_weights}
\alias{vd_weights}
\title{Calculates Valliant and Dever weights}
\usage{
vd_weights(convenience_propensities, reference_propensities, g = 5)
}
\arguments{
\item{convenience_propensities}{A vector with the propensities associated with the convenience sample.}

\item{reference_propensities}{A vector with the propensities associated with the reference sample.}

\item{g}{The number of strata to use; by default, its value is 5.}
}
\value{
A vector with the corresponding weights.
}
\description{
Computes weights from propensity estimates using the propensity stratification 1/p_i averaging formula introduced in Valliant and Dever (2011).
}
\details{
The function takes the vector of propensities \eqn{\pi(x)} and calculates the weights to be applied in the Horvitz-Thompson estimator using the formula that can be found in Valliant and Dever (2019). The vector of propensities is divided in \emph{g} strata (ideally five according to Cochran, 1968) aiming to have individuals with similar propensities in each strata. After the stratification, weight is calculated as follows for an individual \emph{i}:
\deqn{w_i = \frac{n(g_i)}{ \sum_{k \in g_i} \pi_k (x)}}
where \eqn{g_i} represents the strata to which \emph{i} belongs, and \eqn{n(g_i)} is the number of individuals in the \eqn{g_i} strata.
}
\examples{
covariates = c("education_primaria", "education_secundaria")
data_propensities = propensities(sampleNP, sampleP, covariates)
vd_weights(data_propensities$convenience, data_propensities$reference)
}
\references{
Valliant, R., & Dever, J. A. (2011). \emph{Estimating propensity adjustments for volunteer web surveys.} Sociological Methods & Research, 40(1), 105-137.

Cochran, W. G. (1968). \emph{The Effectiveness of Adjustment by Subclassification in Removing Bias in Observational Studies.} Biometrics, 24(2), 295-313
}
