% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{migrane_dose_df}
\alias{migrane_dose_df}
\title{Migraine Dose–Response Trial Data}
\format{
A data frame with 8 observations and 3 variables:
\describe{
  \item{dose}{Dose level administered (numeric)}
  \item{painfree}{Number of participants who achieved pain freedom at 2 hours postdose (integer)}
  \item{ntrt}{Total number of treated participants at the corresponding dose level (integer)}
}
}
\source{
Data taken from the DoseFinding package version 1.4-1
}
\usage{
data(migrane_dose_df)
}
\description{
This dataset, migrane_dose_df, is a data frame obtained from a randomized, placebo-controlled
dose–response clinical trial for the treatment of acute migraine (clinicaltrials.gov identifier
NCT00712725). The primary endpoint was “pain freedom at 2 hours postdose,” measured as a binary outcome.
The dataset includes dose levels, the number of participants achieving pain freedom, and the total number
of treated participants at each dose level. These data are useful for dose–response modeling and
clinical trial analysis in migraine research.
}
\details{
The dataset name has been kept as migrane_dose_df to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix df indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
