% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonSGZ.r
\name{PoissonSGZ}
\alias{PoissonSGZ}
\alias{dpois.shifted.gz}
\alias{ppois.shifted.gz}
\alias{qpois.shifted.gz}
\alias{rpois.shifted.gz}
\alias{hpois.shifted.gz}
\title{Poisson Shifted Gompertz (PSG) Distribution}
\usage{
dpois.shifted.gz(x, alpha, beta, lambda, log = FALSE)
ppois.shifted.gz(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.shifted.gz(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.shifted.gz(n, alpha, beta, lambda)
hpois.shifted.gz(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.shifted.gz}: numeric vector of (log-)densities
  \item \code{ppois.shifted.gz}: numeric vector of probabilities
  \item \code{qpois.shifted.gz}: numeric vector of quantiles
  \item \code{rpois.shifted.gz}: numeric vector of random variates
  \item \code{hpois.shifted.gz}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson Shifted Gompertz distribution.
}
\details{
The Poisson Shifted Gompertz distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson Shifted Gompertz distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \frac{1}{\left(1-e^{-\lambda}\right)}\left\{1-\exp 
\left[-\lambda\left\{1-\left(1-e^{-\beta x}\right) 
\exp \left(-\alpha e^{-\beta x}\right)\right\}\right]\right\}\quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dpois.shifted.gz()} — Density function
  \item \code{ppois.shifted.gz()} — Distribution function
  \item \code{qpois.shifted.gz()} — Quantile function
  \item \code{rpois.shifted.gz()} — Random generation
  \item \code{hpois.shifted.gz()} — Hazard function
}
}
\examples{
x <- seq(0.1, 10, 0.2)
dpois.shifted.gz(x, 2.0, 0.5, 0.2)
ppois.shifted.gz(x, 2.0, 0.5, 0.2)
qpois.shifted.gz(0.5, 2.0, 0.5, 0.2)
rpois.shifted.gz(10, 2.0, 0.5, 0.2)
hpois.shifted.gz(x, 2.0, 0.5, 0.2)

# Data
x <- fibers63  
# ML estimates
params = list(alpha=13.5877, beta=2.0139, lambda=18.8875)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.shifted.gz, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.shifted.gz, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.shifted.gz, pfun=ppois.shifted.gz, plot=FALSE)
print.gofic(out)

}
\references{
Chaudhary,A.K., & Kumar, V. (2021). 
Poisson Shifted Gompertz Distribution: Properties and Applications. 
\emph{ International Journal of Recent Technology and Engineering (IJRTE)}
,\bold{9(5)},202--208. \doi{10.35940/ijrte.E5265.019521}
}
