% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid.R
\name{hybrid}
\alias{hybrid}
\title{Hybrid Centrality}
\usage{
hybrid(A, BC = c("standard", "random"), beta)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{BC}{How should the betweenness centrality be computed?
Defaults to \code{"random"}.
Set to \code{"standard"} for standard \code{\link[NetworkToolbox]{betweenness}}.}

\item{beta}{Beta parameter to be passed to the \code{\link[NetworkToolbox]{rspbc}} function
Defaults to .01}
}
\value{
A vector of hybrid centrality values for each node in the network
(higher values are more central, lower values are more peripheral)
}
\description{
Computes hybrid centrality of each node in a network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

HC <- hybrid(A)
}
\references{
Christensen, A. P., Kenett, Y. N., Aste, T., Silvia, P. J., & Kwapil, T. R. (2018).
Network structure of the Wisconsin Schizotypy Scales-Short Forms:
Examining psychometric network filtering approaches.
\emph{Behavior Research Methods}, \emph{50}, 2531-2550.

Pozzi, F., Di Matteo, T., & Aste, T. (2013).
Spread of risk across financial markets: Better to invest in the peripheries. 
\emph{Scientific Reports}, \emph{3}, 1655.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
