% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareEdgelistNetworks.R
\name{CompareEdgelistNetworks}
\alias{CompareEdgelistNetworks}
\alias{CEN}
\title{Statistical Comparison of Networks based on Edgelists}
\usage{
CEN(EL1, EL2, noc, it = 10000,
             paired = FALSE, directed = FALSE, abs = TRUE, plot = TRUE,
             test.edges = TRUE, edges = "all", progressbar = TRUE,
             p.adjust.methods = c("none", "holm", "hochberg","hommel",
                                   "bonferroni", "BH", "BY", "fdr"),
             test.centrality = TRUE, centrality = c("all"), cen.nodes = "all",
             test.bridge.centrality = FALSE, bridge.centrality = c("all"),
             brg.nodes= "all", communities = NULL, useCommunities = "all",
             verbose = TRUE)
}
\arguments{
\item{EL1}{Edgelist 1. One of two edgelists containing the subject number and the coding of the network. The object type is "data.frame", the columns must be labeled "person", "from" and "to". "Person" contains the subject number. For dependent samples, the same person must have the same label in both edgelists. For independent samples, the same subject number cannot occur twice in the two edgelists. "From" indicates where an edge begins, "to" indicates where it ends. For undirected networks, an edge can be specified in one direction only. The direction is irrelevant (e.g., from 1 to 2, or from 2 to 1). The nodes must be numbered and must not have labels of the class character. The example serves as an orientation for the structure of the data frame.}

\item{EL2}{Edgelist 2. The other of two edgelists containing the subject number and the coding of the network. The object type is "data.frame", the columns must be labeled "person", "from" and "to". "Person" contains the subject number. For dependent samples, the same person must have the same label in both edgelists. For independent samples, the same subject number cannot occur twice in the two edgelists. "From" indicates where an edge begins, "to" indicates where it ends. For undirected networks, an edge can be specified in one direction only. The direction is irrelevant (e.g., from 1 to 2, or from 2 to 1). The nodes must be numbered and must not have labels of the class character. The example serves as an orientation for the structure of the data frame.}

\item{noc}{Number of nodes. Total number of nodes that occur in the networks.}

\item{it}{Iterations. The number of iterations (permutations). Defaults to 10.000. The ideal number of permutations can be calculated in advance using the R package 'coin'.}

\item{paired}{Logical. Can be TRUE or FALSE to indicate whether the samples are dependent or not. If paired is TRUE, relabeling is performed within each pair of observations. If paired is FALSE, relabeling is not restricted to pairs of observations. Note that, currently, dependent data is assumed to entail one group measured twice. Defaults to FALSE.}

\item{directed}{Logical. Can be TRUE or FALSE to indicate whether the networks are directed or not. Undirected networks have edges without directions. For directed networks, the edges are often represented with arrows in one direction, however, the arrow can also point in both directions. Defaults to FALSE.}

\item{abs}{Logical. Should global strength consider the absolute value of edge weights, or the raw value (i.e., global expected influence)? Important if the edgelists contain negative values. Defaults to TRUE.}

\item{plot}{Logical. Should the networks be displayed graphically? Defaults to TRUE.}

\item{test.edges}{Logical. Can be TRUE or FALSE to indicate whether or not differences in individual edges should be tested. Defaults to TRUE.}

\item{edges}{Character or list. When 'all', differences between all individual edges are tested. When provided a list with one or more pairs of nodes, the provided edges are tested. The list must contain the two nodes that delimit the edge, e.g., edges = list(c(1,2), c(3,2)).}

\item{progressbar}{Logical. Should the progressbar be plotted in order to see the progress of the permutation procedure? Defaults to TRUE.}

\item{p.adjust.methods}{Character. Can be one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", or "none". To control (or not) for testing of multiple edges. Defaults to "none".}

\item{test.centrality}{Logical. Should centrality metrics be compared across networks? Defaults to FALSE.}

\item{centrality}{Type of centrality metrics to test. Can be either "all" or individually selected. For undirected networks it can be any of c("Closeness", "Betweenness", "Strength", "ExpectedInfluence"). For directed networks it can be any of c("Closeness", "Betweenness", "InStrength", "OutStrength", "InExpectedInfluence", "OutExpectedInfluence"). For more information see '\link[qgraph]{centrality}'.}

\item{cen.nodes}{Specific nodes for centrality tests. Indicated by the node numbers, e.g., c(1,3), to test node 1 and 3. Only used if test.centrality = TRUE.}

\item{test.bridge.centrality}{Logical. Should bridge centrality metrics be compared across networks? Defaults to FALSE.}

\item{bridge.centrality}{Type of bridge centrality metrics to test. Currently, only "all" can be selected.}

\item{brg.nodes}{Specific nodes for bridge centrality tests. Indicated by the node numbers, e.g., c(1,3), to test node 1 and 3. Only used if test.bridge.centrality = TRUE.}

\item{communities}{A character vector of community assignments for each node (e.g., c("Comm1", "Comm1", "Comm2", "Comm2)). The ordering of this vector should correspond to the order of the nodes. Can also be in list format (e.g., list("Comm1"=c(1:3), "Comm2"=c(4:6))). For more information see '\link[networktools]{bridge}'.}

\item{useCommunities}{A character vector specifying which communities should be included. Default set to "all". For more information see '\link[networktools]{bridge}'.}

\item{verbose}{Logical: Should warnings and notes be printed?}
}
\value{
CompareEdgelistNetworks returns an object of class "CEN" containing the following items:

\strong{glstrinv.real} The difference in global strength between the networks of the observed data sets.

\strong{glstrinv.sep} The global strength values of the individual networks.

\strong{glstrinv.pval} The p value resulting from the permutation test concerning difference in global strength.

\strong{glstrinv.perm}	The difference in global strength between the networks of the permutated data sets.

\strong{nwinv.real} The value of the maximum difference in edge weights of the observed networks.

\strong{nwinv.pval} The p value resulting from the permutation test concerning the maximum difference in edge weights.

\strong{nwinv.perm} The values of the maximum difference in edge weights of the permuted networks.

\strong{edges.tested} The edges, that are called to be tested. Only if test.edges = TRUE.

\strong{einv.real} The values of the differences in edge count of the observed networks. This can be either of all edges or of the selected edge(s). Only if test.edges = TRUE.

\strong{einv.pvals} p-values (corrected for multiple testing or not according to 'p.adjust.methods') per edge from the permutation test concerning differences in edges count. Only returned if test.edges = TRUE.

\strong{einv.perm}	The values of the differences in edge count of the permuted networks. Only if test.edges = TRUE.

\strong{diffcen.real} The values of the difference in centralities of the observed networks. Only if test.centrality = TRUE.

\strong{diffcen.pval} p-values (corrected for multiple testing or not according to 'p.adjust.methods') per node from the permutation test concerning differences in centralities. Only if test.centrality = TRUE.

\strong{diffcen.perm} The values of the difference in centralities of the permuted networks. Only if test.centrality = TRUE.

\strong{cen.nw1}	Values of the selected centrality measures of network 1.

\strong{cen.nw2}	Values of the selected centrality measures of network 2.

\strong{cen.plot1}	Visualization of the selected centrality measures of network 1.

\strong{cen.plot2}	Visualization of the selected centrality measures of network 2.

\strong{diffbcen.real}	The values of the difference in bridge centralities of the observed networks. Only if test.bridge.centrality = TRUE.

\strong{diffbcen.pval}	p-values (corrected for multiple testing or not according to 'p.adjust.methods') per node from the permutation test concerning differences in bridge centralities. Only if test.bridge.centrality = TRUE.

\strong{diffbcen.perm}	The values of the difference in bridge centralities of the permuted networks. Only if test.bridge.centrality = TRUE.

\strong{bridgecen.nw1}	Values of the selected bridge centrality measures of network 1.

\strong{bridgecen.nw2} Values of the selected bridge centrality measures of network 2.

\strong{bridge.plot1} Visualization of the selected bridge centrality measures of network 1.

\strong{bridge.plot2} Visualization of the selected bridge centrality measures of network 2.

\strong{info} Returns the selected arguments of the CEN usage.
}
\description{
This permutation-based hypothesis test assesses the differences between two networks based on the invariance measures of the R package 'NetworkComparisonTest' by van Borkulo et al. (2022): global strength invariance, network structure invariance, edge invariance, and various centrality measures. The global strength invariance represents the differences in the total number of all edges. The network structure invariance involves only the edge that differs the most in its count. The edge invariance covers the differences of the specified individual edges. The centrality measures covers the differences regarding the importance of the individual nodes. Edgelists of two comparable group networks from dependent or independent samples are used as input. These edgelists can be generated from individual graphical network representations, such as concept maps. The networks can be directed or undirected.
}
\details{
This function is predominantly based on the R package '\pkg{NetworkComparisonTest}' by van Borkulo et al. (2022). By changing the input in the form of existing edgelists, the usage has been changed.
}
\examples{
###Simulate datasets with a dependent sample and directed networks
#For an example with an undependent sample and undirected networks see README
data1 <- dplyr::tibble(person = c("1","1","2","2","2","3","3","3","4","4","4","4","4","5","5"),
                      from =    c("1","3","3","1","4","3","1","3","1","4","3","3","3","2","1"),
                      to =      c("3","4","4","3","2","1","3","4","3","3","4","2","4","4","3"))
data2 <- dplyr::tibble(person = c("1","2","2","3","3","3","3","3","3","3","4","4","4","5","5","5"),
                      from =    c("1","1","1","1","2","1","2","4","4","3","1","3","2","1","1","3"),
                      to =      c("2","2","4","2","4","4","3","3","1","4","2","2","1","4","2","4"))

### Compare networks of data sets using CEN
Res <- CEN(data1, data2, noc=4, it=50, paired=TRUE, directed=TRUE, abs=TRUE,
            test.edges=TRUE, edge=list(c(1,3),c(4,2),c(3,2)), p.adjust.methods= "none",
            test.centrality=TRUE, centrality=c("Closeness", "Betweenness"), cen.nodes="all",
            test.bridge.centrality=FALSE, bridge.centrality="all", brg.nodes=c(1,3),
            communities=c("1","1","2","2"), useCommunities="all")

###See results
summary(Res)
print(Res)
Res$glstrinv.sep
Res$glstrinv.pval
Res$nwinv.real
Res$nwinv.pval
Res$einv.real
Res$einv.pvals
Res$diffcen.real
Res$diffcen.pval

###Plot results
plot(Res, what="network")
plot(Res, what="strength")
plot(Res, what="edge")
plot(Res, what="centrality")


}
