% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSR.R
\name{NSR}
\alias{NSR}
\title{Check the native status for plant species in a political region}
\usage{
NSR(occurrence_dataframe, ...)
}
\arguments{
\item{occurrence_dataframe}{A properly formatted dataframe, see https://bien.nceas.ucsb.edu/bien/tools/nsr/batch-mode/}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
Dataframe containing NSR results.
}
\description{
NSR returns information on native status for species within a political region.
}
\examples{
\dontrun{

results <- NSR(occurrence_dataframe = nsr_testfile)
  
# Inspect the results
head(results, 10)
# That's a lot of columns. Let's display one row vertically
# to get a better understanding of the output fields
results.t <- t(results[,2:ncol(results)]) 
results.t[,1,drop =FALSE]
# Summarize the main results
results[ 1:10, 
c("species", "country", "state_province", "native_status", "native_status_reason")]

# Compare summary flag isIntroduced to more detailed native_status values
# and inspect souces consulted
results[ 1:10, 
c("species", "country", "state_province", "native_status", "isIntroduced", "native_status_sources")]




}
}
