% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPC_AAM.R
\name{MPC_AAM}
\alias{MPC_AAM}
\title{MPC_AAM}
\usage{
MPC_AAM(specdat, withBC = TRUE)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data.}

\item{withBC}{A logical parameter that enables/disables baseline correction after baseline correction}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
Multiple single linear models that minimize absolute area.
}
\details{
This function is used to process phase error correction through multiple single linear models that minimize absolute area, followed by polynomial baseline correction when necessary.
}
\examples{
data("fdat")
mpc_aam_phased1 <- MPC_AAM(fdat$frequency_domain)
}
\references{
de Brouwer, H. (2009). Evaluation of algorithms for automated phase correction of NMR spectra. J Magn Reson, 201, 230-238.

Dzakula, Z. (2000). Phase angle measurement from peak areas (PAMPAS). J Magn Reson, 146, 20-32.

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
