% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{updateFocus}
\alias{updateFocus}
\title{Update Focus}
\usage{
updateFocus(NGLVieweR_proxy, focus = 0)
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{focus}{Numeric value between 0-100 (default = 0).}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message
parameters.
}
\description{
Update the focus of an existing NGLVieweR object in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\%
  updateFocus(focus = 50)
}

if (interactive()) {
  library(shiny)
  ui = fluidPage(
    titlePanel("Viewer with API inputs"),
    sidebarLayout(
      sidebarPanel(
        sliderInput("focus", "Focus", 0, 100, 50)
      ),
      mainPanel(
        NGLVieweROutput("structure")
      )
    )
  )
  server = function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        addRepresentation("cartoon",
        param = list(name = "cartoon", color= "red"))
    })
    observeEvent(input$focus, {
      NGLVieweR_proxy("structure") \%>\%
        updateFocus(input$focus)
    })
  }
shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=setFocus]{setFocus()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "updateFocus".
}

Other options: 
\code{\link{setFocus}()},
\code{\link{setQuality}()},
\code{\link{snapShot}()},
\code{\link{updateFullscreen}()}
}
\concept{options}
