% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAPprior_bin.R
\name{MAPprior_bin}
\alias{MAPprior_bin}
\title{Analysis for binary data using the MAP Prior approach}
\usage{
MAPprior_bin(
  data,
  arm,
  alpha = 0.025,
  opt = 2,
  prior_prec_tau = 4,
  prior_prec_eta = 0.001,
  n_samples = 1000,
  n_chains = 4,
  n_iter = 4000,
  n_adapt = 1000,
  robustify = TRUE,
  weight = 0.1,
  check = TRUE,
  ...
)
}
\arguments{
\item{data}{Data frame with trial data, e.g. result from the \code{datasim_bin()} function. Must contain columns named 'treatment', 'response' and 'period'.}

\item{arm}{Integer. Index of the treatment arm under study to perform inference on (vector of length 1). This arm is compared to the control group.}

\item{alpha}{Double. Decision boundary (one-sided). Default=0.025}

\item{opt}{Integer (1 or 2). If opt==1, all former periods are used as one source; if opt==2, periods get separately included into the final analysis. Default=2.}

\item{prior_prec_tau}{Double. Precision parameter (\eqn{1/\sigma^2_{\tau}}) of the half normal hyperprior, the prior for the between study heterogeneity. Default=4.}

\item{prior_prec_eta}{Double. Precision parameter (\eqn{1/\sigma^2_{\eta}}) of the normal hyperprior, the prior for the hyperparameter mean of the control log-odds. Default=0.001.}

\item{n_samples}{Integer. Number of how many random samples will get drawn for the calculation of the posterior mean, the p-value and the CI's. Default=1000.}

\item{n_chains}{Integer. Number of parallel chains for the rjags model. Default=4.}

\item{n_iter}{Integer. Number of iterations to monitor of the jags.model. Needed for coda.samples. Default=4000.}

\item{n_adapt}{Integer. Number of iterations for adaptation, an initial sampling phase during which the samplers adapt their behavior to maximize their efficiency. Needed for jags.model. Default=1000.}

\item{robustify}{Logical. Indicates whether a robust prior is to be used. If TRUE, a mixture prior is considered combining a MAP prior and a weakly non-informative component prior. Default=TRUE.}

\item{weight}{Double. Weight given to the non-informative component (0 < weight < 1) for the robustification of the MAP prior according to Schmidli (2014). Default=0.1.}

\item{check}{Logical. Indicates whether the input parameters should be checked by the function. Default=TRUE, unless the function is called by a simulation function, where the default is FALSE.}

\item{...}{Further arguments passed by wrapper functions when running simulations.}
}
\value{
List containing the following elements regarding the results of comparing \code{arm} to control:
\itemize{
\item \code{p-val} - posterior probability that the log-odds ratio is less than zero
\item \code{treat_effect} - posterior mean of log-odds ratio
\item \code{lower_ci} - lower limit of the (1-2*\code{alpha})*100\% credible interval for log-odds ratio
\item \code{upper_ci} - upper limit of the (1-2*\code{alpha})*100\% credible interval for log-odds ratio
\item \code{reject_h0} - indicator of whether the null hypothesis was rejected or not (\code{p_val} < \code{alpha})
}
}
\description{
This function performs analysis of binary data using the Meta-Analytic-Predictive (MAP) Prior approach. The method borrows data from non-concurrent controls to obtain the prior distribution for the control response in the concurrent periods.
}
\details{
The MAP approach derives the prior distribution for the control response in the concurrent periods by combining the control information from the non-concurrent periods with a non-informative prior.

The model for the binary response \eqn{y_{js}} for the control patient \eqn{j} in the non-concurrent period \eqn{s} is defined as follows:

\deqn{g(E(y_{js})) = \eta_s}

where \eqn{g(\cdot)} denotes the logit link function and \eqn{\eta_s} represents the control log odds in the non-concurrent period \eqn{s}.

The log odds for the non-concurrent controls in period \eqn{s} are assumed to have a normal prior distribution with mean \eqn{\mu_{\eta}} and variance \eqn{\tau^2}:

\deqn{\eta_s \sim \mathcal{N}(\mu_{\eta}, \tau^2)}

For the hyperparameters \eqn{\mu_{\eta}} and \eqn{\tau}, normal and half-normal hyperprior distributions are assumed, with mean 0 and variances \eqn{\sigma^2_{\eta}} and \eqn{\sigma^2_{\tau}}, respectively:

\deqn{\mu_{\eta} \sim \mathcal{N}(0, \sigma^2_{\eta})}

\deqn{\tau \sim HalfNormal(0, \sigma^2_{\tau})}

The MAP prior distribution \eqn{p_{MAP}(\eta_{CC})} for the control response in the concurrent periods is then obtained as the posterior distribution of the parameters \eqn{\eta_s} from the above specified model.

If \code{robustify=TRUE}, the MAP prior is robustified by adding a weakly-informative mixture component \eqn{p_{\mathrm{non-inf}}}, leading to a robustified MAP prior distribution:

\deqn{p_{rMAP}(\eta_{CC}) = (1-w) \cdot p_{MAP}(\eta_{CC}) + w \cdot p_{\mathrm{non-inf}}(\eta_{CC})}

where \eqn{w} (parameter \code{weight}) may be interpreted as the degree of skepticism towards borrowing strength.

In this function, the argument \code{alpha} corresponds to \eqn{1-\gamma}, where \eqn{\gamma} is the decision boundary. Specifically, the posterior probability of the difference distribution under the null hypothesis is such that:
\eqn{P(p_{treatment}-p_{control}>0) \ge 1-}\code{alpha}.
In case of a non-informative prior this coincides with the frequentist type I error.
}
\examples{

trial_data <- datasim_bin(num_arms = 3, n_arm = 100, d = c(0, 100, 250),
p0 = 0.7, OR = rep(1.8, 3), lambda = rep(0.15, 4), trend="stepwise")

MAPprior_bin(data = trial_data, arm = 3)


}
\references{
Robust meta-analytic-predictive priors in clinical trials with historical control information. Schmidli, H., et al. Biometrics 70.4 (2014): 1023-1032.

Applying Meta-Analytic-Predictive Priors with the R Bayesian Evidence Synthesis Tools. Weber, S., et al. Journal of Statistical Software 100.19 (2021): 1548-7660.
}
\author{
Katharina Hees
}
