% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transf_value_to_label}
\alias{transf_value_to_label}
\title{Convert values to labels for categorical variables}
\usage{
transf_value_to_label(data, transf_sess_id = FALSE)
}
\arguments{
\item{data}{tibble. The labelled dataset}

\item{transf_sess_id}{logical. Whether to transform the \code{session_id} column}
}
\value{
A tibble with factor columns transformed to labels.
}
\description{
Converts the values of categorical/factor columns (e.g., \code{"1"}, \code{"2"}) to
their labels (e.g., \code{"Male"}, \code{"Female"}). The value labels will be set to
the values.
}
\details{
\subsection{Input requirements}{

The data must be type transformed and labelled. See
\code{\link[=transf_factor]{transf_factor()}} and \code{\link[=transf_label]{transf_label()}} for details.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{data <- data |>
  transf_factor() |>
  transf_label()
}\if{html}{\out{</div>}}
}
}
\examples{
\dontrun{
transf_value_to_label(data)
transf_value_to_label(data, value_to_na = TRUE)
}
}
