% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgpca.r
\name{mgpca}
\alias{mgpca}
\title{Performs a Multigroup PCA analysis in the
given multigroup data matrix.
Show mgpca graphical output.}
\usage{
mgpca(
  mat.to.diag,
  mat.x,
  cls,
  Plot = TRUE,
  ncomp = 2,
  center = TRUE,
  scale = TRUE
)
}
\arguments{
\item{mat.to.diag}{is a matrix with the data}

\item{mat.x}{is a vector of classes}

\item{cls}{group}

\item{Plot}{grafics output of mgpca}

\item{ncomp}{number of component}

\item{center}{is a logical vector where TRUE is center (whether the variables should be
shifted to be zero centered), if is FALSE, is original data.}

\item{scale}{is a logical vector where TRUE is scale (indicating whether
the variables should be scaled), if is FALSE, is original data.}
}
\value{
\strong{If simplify == TRUE} class values.
        \strong{If simplify == FALSE}, the result is a list of length
        \code{nsim} data.tables.
}
\description{
Performs a Multigroup PCA analysis in the
given multigroup data matrix.
Show mgpca graphical output.
}
\examples{
library(plsgenomics)
data(SRBCT)
mydata<-SRBCT$X
mydata<-mydata[1:50,1:5]
groups<-as.factor(SRBCT$Y)[1:50]
mat.to.diag1<-new.cov(x=mydata,cls=groups,A=diag(ncol(mydata)))
mgpca(mat.to.diag=mat.to.diag1,mat.x=as.matrix(mydata),
cls=groups,Plot=TRUE,ncomp=2,center = TRUE,scale = TRUE)
}
