% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcBPvar.R
\name{calcBPvar}
\alias{calcBPvar}
\title{Calculate variability of breakpoints}
\usage{
calcBPvar(regions_results, noregions, pct = 0.05, criterion = "aic")
}
\arguments{
\item{regions_results}{a \code{regions_results} object; the output of a call to \code{\link[=calcregions]{calcregions()}} or \code{\link[=addregions]{addregions()}}.}

\item{noregions}{the number of regions for which the weighted mean and standard deviation are to be computed.}

\item{pct}{the proportion of best model to keep from the original total number of possible models}

\item{criterion}{string; the criterion used to compute the weights. Allowable options include \code{"aic"} and \code{"bic"}. Abbreviations allowed.}
}
\value{
A \code{regions_BPvar} object, which has two components:
\itemize{
\item \code{WeightedBP} is a matrix containing the weighted mean and standard deviation of each breakpoint
\item \code{BestModels} is a data frame containing the models used to compute the weighted breakpoint statistics and the weights each one is given.
}
}
\description{
\code{calcBPvar()} computes an estimate of the variability of the breakpoints for a given number of regions. This involves computing the weighted mean and standard deviation of each breakpoint using Akaike weights.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Fit segmented regression models for 1 to 7 regions
# using PCOs 1 to 4 and a continuous model with a
# exhaustive search
regionresults <- calcregions(alligator_PCO,
                             scores = 1:4,
                             noregions = 7,
                             minvert = 3,
                             cont = TRUE,
                             exhaus = TRUE,
                             verbose = FALSE)

# Compute Akaike-weighted location and SD of optimal
# breakpoints using top 10\% of models with 4 regions
calcBPvar(regionresults, noregions = 4,
          pct = .1, criterion = "aic")
}
\seealso{
\code{\link[=calcregions]{calcregions()}} for fitting segmented regression models to all combinations of breakpoints.
}
