% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimCopulaSeries.R
\name{SimCopulaSeries}
\alias{SimCopulaSeries}
\title{Simulation of a copula-based time series}
\usage{
SimCopulaSeries(family, n, tau = 0, param = NULL)
}
\arguments{
\item{family}{"ind", "tent", "gaussian", "t" , "clayton", "fgm", "frank", "gumbel", joe" , "plackett"}

\item{n}{length of the time series}

\item{tau}{Kendall's tau of the copula family}

\item{param}{extra copula parameter: for "fgm",  param is the dimension of the copula; for "t", param = nu}
}
\value{
\item{U}{Simulated time series}
}
\description{
This function simulates a Markovian time series (p-Markov for the Farlie-Gumbel-Morgenstern copula) with uniform margins using a copula family for the joint distribution of U[t], U[t-1].
}
\examples{
U = SimCopulaSeries("fgm",100,0.2, 3) # for the FGM, |tau|<= 2/9
}
\references{
B.R Nasri (2022). Tests of serial dependence for arbitrary distributions
}
\author{
Bouchra R. Nasri January 2021
}
