% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DependogramZ.R
\name{DependogramZ}
\alias{DependogramZ}
\title{Dependogram for Moebius correlations}
\usage{
DependogramZ(out, n)
}
\arguments{
\item{out}{List of the output from EstDep, EstDepSerial, TestIndCopula or TestIndSerCopula (P-values, subsets)}

\item{n}{Number of observations}
}
\description{
This function, used in EstDepMoebius and EstDepSerialMoebius plot the graphs of the correlation statistics of Spearman, van der Waerden and Savage as a function of the subsets for tests of randomness or test of independence between random variables. Under the null hypothesis, the statistics should be independent N(0,1).
}
\examples{
x <- matrix(rnorm(250),ncol=5)
out <-EstDepMoebius(x)
DependogramZ(out,50)

}
\references{
Nasri & Remillard (2023). Tests of independence and randomness for arbitrary data using copula-based covariances
}
