% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients.R
\name{integrate_function}
\alias{integrate_function}
\title{Robust integration helper function}
\usage{
integrate_function(f, x, alpha, beta, delta, omega, upper = 50, eps = 1e-08)
}
\arguments{
\item{f}{Function. The integrand function to be evaluated.}

\item{x}{Numeric vector. Observations at which the integral is computed.}

\item{alpha}{Numeric scalar. Stability parameter of the stable distribution
(0 < \eqn{\alpha \le 2}), controlling tail thickness.}

\item{beta}{Numeric scalar. Skewness parameter of the stable distribution
(\eqn{-1 \le \beta \le 1}).}

\item{delta}{Numeric scalar. Location parameter of the stable distribution.}

\item{omega}{Numeric scalar. Scale parameter of the stable distribution
(omega > 0).}

\item{upper}{Numeric scalar. Upper limit of integration (default = 50).}

\item{eps}{Numeric scalar. Tolerance for numerical integration (default = 1e-8).}
}
\value{
Numeric vector of integral values evaluated at each element of \code{x}.
}
\description{
Applies `safe_integrate` to a given integrand over a vector of x values.
}
