% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{clean_pq}
\alias{clean_pq}
\title{Clean phyloseq object by removing empty samples and taxa}
\usage{
clean_pq(
  physeq,
  remove_empty_samples = TRUE,
  remove_empty_taxa = TRUE,
  clean_samples_names = TRUE,
  silent = FALSE,
  verbose = FALSE,
  force_taxa_as_columns = FALSE,
  force_taxa_as_rows = FALSE,
  reorder_taxa = FALSE,
  rename_taxa = FALSE,
  simplify_taxo = FALSE,
  prefix_taxa_names = "_Taxa"
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{remove_empty_samples}{(logical) Do you want to remove samples
without sequences (this is done after removing empty taxa)}

\item{remove_empty_taxa}{(logical) Do you want to remove taxa
without sequences (this is done before removing empty samples)}

\item{clean_samples_names}{(logical) Do you want to clean samples names?}

\item{silent}{(logical) If true, no message are printing.}

\item{verbose}{(logical) Additional informations in the message
the verbose parameter overwrite the silent parameter.}

\item{force_taxa_as_columns}{(logical) If true, if the taxa are rows
transpose the otu_table and set taxa_are_rows to false}

\item{force_taxa_as_rows}{(logical) If true, if the taxa are columns
transpose the otu_table and set taxa_are_rows to true}

\item{reorder_taxa}{(logical) if TRUE the otu_table is ordered by the number of
sequences of taxa (ASV, OTU) in descending order. Default to FALSE.}

\item{rename_taxa}{(logical) if TRUE, taxa (ASV, OTU) are renamed by their position
in the OTU_table and prefix_taxa_names param (by default: Taxa_1, Taxa_2, ...).
Default to FALSE. If rename taxa (ASV, OTU) is true,
the taxa (ASV, OTU) names in verbose information can be misleading.}

\item{simplify_taxo}{(logical) if TRUE, correct the taxonomy_table using the
\code{MiscMetabar::simplify_taxo()} function}

\item{prefix_taxa_names}{(default "Taxa_"): the prefix of taxa names (eg. "ASV_" or "OTU_")}
}
\value{
A new \code{\link[phyloseq]{phyloseq-class}} object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


In addition, this function check for discrepancy (and rename) between
(i) taxa names in refseq, taxonomy table and otu_table and between
(ii) sample names in sam_data and otu_table.
}
\author{
Adrien Taudière
}
