% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Minirand.R
\name{Minirand}
\alias{Minirand}
\title{Minimization randomization to k treatment groups}
\usage{
Minirand(covmat = covmat, j, covwt = covwt, ratio = ratio,
  ntrt = ntrt, trtseq = trtseq, method = "Range", result = res, p)
}
\arguments{
\item{covmat}{matrix or data frame of covariate factors}

\item{j}{the jth subject in the randomization sequence}

\item{covwt}{vector of weights of the covaraite factors}

\item{ratio}{vector of randomization ratios for each treatment}

\item{ntrt}{numeric number of treatment groups}

\item{trtseq}{vector of a sequence of treatment groups}

\item{method}{the method or algorithm for the minimization randomization}

\item{result}{the treatment assignments in subjetcs achieved so far}

\item{p}{the high probability for new assignment}
}
\value{
treatment assignment for the jth subject
}
\description{
The function is used to generate treatment assignment by minimization algorithms.
}
\examples{
ntrt <- 3
nsample <- 120
trtseq <- c(1, 2, 3)
ratio <- c(2, 2, 1)
c1 <- sample(seq(1, 0), nsample, replace = TRUE, prob = c(0.4, 0.6)) 
c2 <- sample(seq(1, 0), nsample, replace = TRUE, prob = c(0.3, 0.7))
c3 <- sample(c(2, 1, 0), nsample, replace = TRUE, prob = c(0.33, 0.2, 0.5)) 
c4 <- sample(seq(1, 0), nsample, replace = TRUE, prob = c(0.33, 0.67)) 
covmat <- cbind(c1, c2, c3, c4) # generate the matrix of covariate factors for the subjects
# label of the covariates 
colnames(covmat) = c("Gender", "Age", "Hypertension", "Use of Antibiotics") 
covwt <- c(1/4, 1/4, 1/4, 1/4) #equal weights
res <- rep(100, nsample) # result is the treatment needed from minimization method
#gernerate treatment assignment for the 1st subject
res[1] = sample(trtseq, 1, replace = TRUE, prob = ratio/sum(ratio)) 
for (j in 2:nsample)
{
# get treatment assignment sequentiall for all subjects
res[j] <- Minirand(covmat=covmat, j, covwt=covwt, ratio=ratio, 
ntrt=ntrt, trtseq=trtseq, method="Range", result=res, p = 0.9)
}
trt1 <- res
#Display the number of randomized subjects at covariate factors
balance1 <- randbalance(trt1, covmat, ntrt, trtseq) 
balance1
totimbal(trt = trt1, covmat = covmat, covwt = covwt, 
ratio = ratio, ntrt = ntrt, trtseq = trtseq, method = "Range")
}
\references{
Pocock and Simon (1975), Sequential Treatment Assignment with Balancing for Prognostic
 Factors in the Controlled Clinical Trial. Biometrics; 103-115.

Jin, Polis, and Hartzel (2019), "Algorithms for minimization randomization and the implementation with an 
R package". Communications in Statistics-Simulation and Computation; May 2019. 
}
