% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVMajorityVotes.R
\name{CVMajorityvotes}
\alias{CVMajorityvotes}
\title{Cross validation for majority votes}
\usage{
CVMajorityvotes(
  Survival,
  Censor,
  Prognostic = NULL,
  Micro.mat,
  Reduce = TRUE,
  Select = 5,
  Fold = 3,
  Ncv = 100,
  Mean = TRUE,
  Quantile = 0.5
)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects.}

\item{Censor}{A vector of censoring indicator.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Micro.mat}{A large or small microbiome profile matrix. A matrix with microbiome profiles where the number of rows should be equal to the number of taxa and number of columns should be equal to number of patients.}

\item{Reduce}{A boolean parameter indicating if the microbiome profile matrix should be reduced, default is TRUE and larger microbiome profile matrix is reduced by supervised pca approach.}

\item{Select}{Number of taxa (default is 5) to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE.}

\item{Fold}{Number of times in which the dataset is divided. Default is 3 which implies dataset will be divided into three groups and 2/3 of the dataset will be the train datset and 1/3 will be to train the results.}

\item{Ncv}{The Number of cross validation loop. Default is 100.}

\item{Mean}{The cut off value for the classifier, default is the mean cutoff.}

\item{Quantile}{If users want to use quantile as cutoff point. They need to specify Mean = FALSE and a quantile that they wish to use. The default is the median cutoff.}
}
\value{
A object of class \code{\link[MicrobiomeSurv]{cvmv}} is returned with the following values
  \item{HRTrain}{A matrix of survival information for the training dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}
  \item{HRTest}{A matrix of survival information for the test dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}
  \item{Ncv}{The number of cross validation used.}
 \item{Micro.mat}{The microbiome data matrix that was used for the analysis either same as Micro.mat or a reduced version.}
  \item{Progfact}{The names of prognostic factors used.}
}
\description{
This function does cross validation for the Majority votes based classification which is a cross validated approach to \code{\link[MicrobiomeSurv]{Majorityvotes}}.
}
\examples{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the function
CVMajority_fam_shan_w3 = CVMajorityvotes(Survival = surv_fam_shan_w3$Survival,
                                         Micro.mat = fam_shan_trim_w3,
                                         Censor = surv_fam_shan_w3$Censor,
                                         Reduce=TRUE,
                                         Select=5,
                                         Mean = TRUE,
                                         Prognostic = prog_fam_shan_w3,
                                         Fold=3,
                                         Ncv=10)

# Get the class of the object
class(CVMajority_fam_shan_w3)     # An "cvmv" Class

# Method that can be used for the result
show(CVMajority_fam_shan_w3)
summary(CVMajority_fam_shan_w3)
plot(CVMajority_fam_shan_w3)
}
\seealso{
\code{\link[MicrobiomeSurv]{Majorityvotes}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
