% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosso.R
\name{is.rosso}
\alias{is.rosso}
\title{Rosso class}
\usage{
is.rosso(x)
}
\arguments{
\item{x}{variable or list.}
}
\value{
\code{TRUE} if the object or all objects are of class \code{rosso}.
}
\description{
Test if a variable or variable list is/are rosso-object(s).
}
\examples{
# TRUE return
r1 <- MicrobialGrowth(example_data$time, example_data$y1, model="rosso")
r2 <- MicrobialGrowth.create(N0 = 0.14, Nmax = 1.43, mu = 0.07, lambda = 45,
                                   xlim = c(0, 100), model="rosso")
is.rosso(r1)
is.rosso(r2)
is.rosso(c(r1, r2))
is.rosso(list(r1,r2))

# FALSE return
is.rosso(1)
is.rosso(list())
is.rosso(c(r1, r2, 1))
is.rosso(list(r1, r2, 1))
}
