% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\docType{data}
\name{controlDefaults}
\alias{controlDefaults}
\title{Control default values}
\format{
albedo: 0.23 [-] for hypothetical grass and alfalfa reference crops used in
the FAO-56 PM equations (e.g. in \code{\link{ETref}}, \code{\link{Rn}} or \code{\link{estG}})  \cr \cr
Po: atmospheric pressure at sea level (101.3 [kPa]) \cr \cr
z0: elevation at reference level (0 [m]) (e.g. in \code{\link{ETref}} or \code{\link{estP}}) \cr \cr
Tko: reference temperature [degreeC] at elevation z0. Often assumed to be 20 degreeC (e.g. in \code{\link{ETref}} or \code{\link{estP}}) \cr \cr
uz: height of windspeed measurement above ground surface (2 [m]) (e.g. in \code{\link{ETref}} or \code{\link{adj_u2}}) \cr \cr
Lz: \cr
longitude of the centre of the local time zone (degrees west of Greenwich)\cr
- 0 for Greenwich\cr
- 345 for Germany\cr
- 330 for Cairo (Egypt)\cr
- 255 for Bangkok (Thailand)\cr
- 75, 90, 105 and 120 for Eastern, Central, Rocky Mountain and Pacific time zones (United States)\cr
Lz is only needed if calculation period is shorter 1 day. \cr \cr
as: regression constant, expressing fraction of extraterrestrial radiation reaching earth on overcast days (default = 0.25) (e.g. in \code{\link{ETref}}, \code{\link{Rn}} or \code{\link{estRs}}) \cr \cr
bs: as + bs fraction of extraterrestrial radiation reaching earth on clear days (default = 0.5) (e.g. in \code{\link{ETref}}, \code{\link{Rn}} or \code{\link{estRs}}) \cr \cr
est.ratio.Rs.Rso: \cr Rs/Rso is used to represent cloud cover. For hourly or shorter periods during the nighttime,
the ratio Rs/Rso is set equal to the Rs/Rso calculated for a time period occurring 2-3 hours before sunset.
If single values during nighttime are calculated Rs/Rso ratio 2-3 hours before sunset can not be calculated
and an approximation is needed. Following Allen (1999) one can assume Rs/Rso = 0.4 to 0.6 during nighttime periods
in humid and subhumid climates and Rs/Rso = 0.7 to 0.8 in arid and semiarid climates. A value of Rs/Rso = 0.3 presumes
total cloud cover.
}
\usage{
controlDefaults
}
\description{
Default values for control. If necessary modify with control = list() in function call.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
\keyword{datasets}
