% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rnl.R
\name{Rnl}
\alias{Rnl}
\title{Net longwave radiation (Rnl)}
\usage{
Rnl(
  x,
  Tmax = NULL,
  Tmin = NULL,
  Rhmax = NULL,
  Rhmin = NULL,
  Rs = NULL,
  lat.rad = NULL,
  lat.deg = NULL,
  long.deg = NULL,
  elev,
  actVP = NULL,
  tl,
  Tmean = NULL,
  Rhmean = NULL,
  control = list()
)
}
\arguments{
\item{x}{date-time object or day of the year (must be date-time object if calculation period is shorter than a day)}

\item{Tmax}{maximum temperature [degreeC] during 24-hour period (for daily values)}

\item{Tmin}{minimum temperature [degreeC] during 24-hour period (for daily values)}

\item{Rhmax}{daily maximum of air humidity [percent] (for daily values)}

\item{Rhmin}{daily minimum of air humidity [percent] (for daily values)}

\item{Rs}{incoming solar radiation [MJ/(m2 time)]}

\item{lat.rad}{latitude [rad]. Use either lat.rad or lat.deg. Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{lat.deg}{latitude [degree]. Use either lat.deg or lat.rad. Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{long.deg}{see \code{\link{Rso}}}

\item{elev}{station elevation above sea level [m]}

\item{actVP}{Actual vapor pressure [kPa]. If Rhmax, Rhmin and Rhmean are NULL}

\item{tl}{length of calculation period [hour] (1 for hourly period, 0.5 for a 30-minute period or 24 for daily period).
Only needed if length of x is date-time object with length of 1.}

\item{Tmean}{mean temperature [degreeC] during the time period (for periods shorter than a day)}

\item{Rhmean}{Mean air humidity [percent] (for periods shorter than a day or if Rhmax and Rhmin are missing)}

\item{control}{list for control parameters and empirical factors (see Details and \code{\link{controlDefaults}})}
}
\value{
Rnl net outgoing longwave radiation [MJ(/m2 time)]
}
\description{
Net longwave radiation (Rnl).
}
\details{
\describe{\item{x:}{
must be provided as.numeric (1-366) or as a common date-time object (e.g, POSIXct, POSIXlt or Date objects).
All formats for which is.timepoint from the lubridate package returns TRUE can be used}}
\describe{\item{control:}{
Lz: \cr
longitude of the centre of the local time zone (degrees west of Greenwich) \cr
- 0 for Greenwich \cr
- 345 for Germany \cr
- 330 for Cairo (Egypt) \cr
- 255 for Bangkok (Thailand) \cr
- 75, 90, 105 and 120 for Eastern, Central, Rocky Mountain and Pacific time zones (United States)\cr
Lz is only needed if calculation period is shorter 1 day.\cr\cr
est.ratio.Rs.Rso: \cr
Rs/Rso is used to represent cloud cover. For hourly or shorter periods during the nighttime,
the ratio Rs/Rso is set equal to the Rs/Rso calculated for a time period occurring 2-3 hours before sunset.
If single values during nighttime are calculated Rs/Rso ration 2-3 hours before sunset can not be calculated
and an approximation is needed. Following Allen (1999) one can assume Rs/Rso = 0.4 to 0.6 during nighttime periods
in humid and subhumid climates and Rs/Rso = 0.7 to 0.8 in arid and semiarid climates. A value of Rs/Rso = 0.3 presumes
total cloud cover.}}
}
\note{
eq. 39 of reference
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
