% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{miso}
\alias{miso}
\title{Fit Bayesian misclassification model (binary)}
\usage{
miso(X, y, incr = 0.01)
}
\arguments{
\item{X}{numeric matrix}

\item{y}{numeric response vector}

\item{incr}{numeric, increment for threshold grid}
}
\value{
A list containing fitted parameters
}
\description{
Fit Bayesian misclassification model (binary)
}
\examples{
A <- as.matrix(expand.grid(rep(list(0:1), 6)))
set.seed(2025)
X <- A[sample(nrow(A),size=500, replace = TRUE),]
y <- as.numeric(rowSums(X)>=3)
miso(X,y)
}
\references{
Cheung YK, Diaz KM. Monotone response surface of multi-factor condition: estimation and Bayes classifiers. 
*J R Stat Soc Series B Stat Methodol.* 2023 Apr;85(2):497-522. 
doi: 10.1093/jrsssb/qkad014. Epub 2023 Mar 22. PMID: 38464683; PMCID: PMC10919322.
}
