% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countyMap.R
\name{countyMap}
\alias{countyMap}
\title{County level thematic map}
\usage{
countyMap(
  data = NULL,
  parameter = NULL,
  state_SFDF = "USCensusStates_02",
  county_SFDF = "USCensusCounties_02",
  breaks = NULL,
  palette = "brewer.blues",
  conusOnly = TRUE,
  stateCode = NULL,
  projection = NULL,
  stateBorderColor = "gray50",
  countyBorderColor = "white",
  title = NULL,
  showLegend = TRUE,
  legendTitle = NULL,
  legendOrientation = c("portrait", "landscape"),
  legendPosition = NULL
)
}
\arguments{
\item{data}{Dataframe containing values to plot. This dataframe
must contain a column named \code{countyFIPS} with the 5-digit FIPS code.}

\item{parameter}{Name of the column in \code{data} to use for coloring the map.}

\item{state_SFDF}{simple features data frame with US states. It's data
\code{@slot} must contain a column named \code{stateCode} if either
\code{conusOnly = TRUE} or the \code{stateCode} argument is specified.}

\item{county_SFDF}{simple features data frame with US counties. It's data
\code{@slot} must always contain a column named and \code{countyFIPS} and a
column named \code{stateCode} if either \code{conusOnly = TRUE} or the
\code{stateCode} argument is specified.}

\item{breaks}{Numeric vector of break points.}

\item{palette}{A vector of colors or palette name from the \pkg{cols4all} package
(see \code{\link[cols4all:c4a]{cols4all::c4a}}).}

\item{conusOnly}{Logical specifying Continental US state codes. Ignored when
the \code{stateCode} argument is specified.}

\item{stateCode}{Vector of state codes to include on the map.}

\item{projection}{Named projection, \emph{e.g.} "EPSG:4326" or "WGS84" or proj4string.}

\item{stateBorderColor}{Color used for state borders.}

\item{countyBorderColor}{Color used for county borders.}

\item{title}{Vector of text strings to use as individual plot titles.
This must be the same length as 'parameter'.}

\item{showLegend}{Logical specifying whether or not to show the legend.}

\item{legendTitle}{Text string to use as the legend title.}

\item{legendOrientation}{Orientation of the legend. Either "portrait" or "landscape".}

\item{legendPosition}{A \emph{tm_pos} object generated with
\code{\link[tmap:tm_pos_in]{tmap::tm_pos_in()}} or
\code{\link[tmap:tm_pos_out]{tmap::tm_pos_out()}}.}
}
\value{
A ggplot object.
}
\description{
Uses the \pkg{tmap} package to generate a thematic map at the
county level. Input consists of a dataframe with \code{countyFIPS} identifiers.

Data to plot is specified with \code{parameter} argument. If \code{parameter}
is mult-valued, mutliple plots will be generated and displayed as "facets".

The returned object is a \pkg{tmap} ggplot object which can be further
modified with tmap or ggplot options.
}
\examples{
\donttest{
library(MazamaSpatialPlots)
mazama_initialize()

countyMap(
  data = example_US_countyCovid,
  parameter = "cases",
  breaks = c(0,100,200,500,1000,2000,5000,10000,20000,50000,1e6),
  title = "COVID-19 Cases on June 01 2020"
)

countyMap(
  data = example_US_countyCovid,
  parameter = "deaths",
  state_SFDF = USCensusStates_02,
  county_SFDF = USCensusCounties_02,
  breaks = c(0, 1, 50, 100, 250, 500, 1000, 2500, 3000),
  palette = "brewer.or_rd",
  stateCode = c( "NY", "PA", "MD", "NJ", "DE"),
  stateBorderColor = "black",
  countyBorderColor = 'grey70'
) +
  tmap::tm_layout(
    attr.color = 'white',
    bg.color = "dodgerblue4"
  ) +
  tmap::tm_title(
    text = "COVID-19 Deaths* in the Mid Atlantic",
    size = 2.0,
    color = "white",
  ) +
  tmap::tm_credits("*as of June 01, 2020", col = "white", position = "left")
}
}
