% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.mmc}
\alias{plot.mmc}
\title{Plot a \code{mmc} Object}
\usage{
\method{plot}{mmc}(x, ...)
}
\arguments{
\item{x}{An object of class \code{mmc}.}

\item{...}{Arguments to be passed to methods, such as \link{graphical parameters} (see \code{\link{par}}).}
}
\value{
The \code{mmc} object is returned invisibly.
}
\description{
The \code{plot()} method for objects of the
class \code{mmc} gives a plot of the best and current p-value found during the iterations of \code{mmc}.
}
\examples{
## Example
library(fUnitRoots)
# Set seed
set.seed(123)

# Generate an AR(2) process with phi = (-1.5,0.5), and n = 25
y <- filter(rnorm(25), c(-1.5, 0.5), method = "recursive")

# Set bounds for the nuisance parameter v
lower <- -1
upper <- 1

# Set the function to generate an AR(2) integrated process
dgp <- function(y, v) {
    ran.y <- filter(rnorm(length(y)), c(1-v,v), method = "recursive")
}

# Set the Augmented-Dicky Fuller statistic
statistic <- function(y){
    out <- suppressWarnings(adfTest(y, lags = 2, type = "nc"))
    return(out@test$statistic)
}

# Apply the mmc procedure
est <- mmc(y, statistic = statistic , dgp = dgp, lower = lower,
           upper = upper, N = 99, type = "leq", method = "GenSA",
           control = list(max.time = 2))

# Plot result of object of class 'mmc'
plot(est)
}
