% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlzMWRoutlierall.R
\name{anlzMWRoutlierall}
\alias{anlzMWRoutlierall}
\title{Analyze outliers in results file for all parameters}
\usage{
anlzMWRoutlierall(
  res = NULL,
  acc = NULL,
  fset = NULL,
  fig_height = 4,
  fig_width = 8,
  format = c("word", "png", "zip"),
  output_dir,
  output_file = NULL,
  type = c("box", "jitterbox", "jitter"),
  group,
  dtrng = NULL,
  repel = TRUE,
  outliers = FALSE,
  labsize = 3,
  fill = "lightgrey",
  alpha = 0.8,
  width = 0.8,
  yscl = "auto",
  ttlsize = 1.2,
  bssize = 11,
  runchk = TRUE,
  warn = TRUE
)
}
\arguments{
\item{res}{character string of path to the results file or \code{data.frame} for results returned by \code{\link{readMWRresults}}}

\item{acc}{character string of path to the data quality objectives file for accuracy or \code{data.frame} returned by \code{\link{readMWRacc}}}

\item{fset}{optional list of inputs with elements named \code{res}, \code{acc}, \code{frecom}, \code{sit}, or \code{wqx} overrides the other arguments}

\item{fig_height}{numeric for plot heights in inches}

\item{fig_width}{numeric for plot width in inches}

\item{format}{character string indicating if results are placed in a word file, as separate png files, or as a zipped file of separate png files in \code{output_dir}}

\item{output_dir}{character string of the output directory for the results}

\item{output_file}{optional character string for the file name if \code{format = "word"}}

\item{type}{character indicating \code{"box"}, \code{"jitterbox"}, or \code{"jitter"}, see details}

\item{group}{character indicating whether the summaries are grouped by month, site, or week of year}

\item{dtrng}{character string of length two for the date ranges as YYYY-MM-DD, optional}

\item{repel}{logical indicating if overlapping outlier labels are offset}

\item{outliers}{logical indicating if outliers are returned to the console instead of plotting}

\item{labsize}{numeric indicating font size for the outlier labels}

\item{fill}{numeric indicating fill color for boxplots}

\item{alpha}{numeric from 0 to 1 indicating transparency of fill color}

\item{width}{numeric for width of boxplots}

\item{yscl}{character indicating one of \code{"auto"} (default), \code{"log"}, or \code{"linear"}, see details}

\item{ttlsize}{numeric value indicating font size of the title relative to other text in the plot}

\item{bssize}{numeric for overall plot text scaling, passed to \code{\link[ggplot2]{theme_minimal}}}

\item{runchk}{logical to run data checks with \code{\link{checkMWRresults}} or \code{\link{checkMWRacc}}, applies only if \code{res} or \code{acc} are file paths}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
A word document named \code{outlierall.docx} (or name passed to \code{output_file}) if \code{format = "word"} or separate png files for each parameter if \code{format = "png"} will be saved in the directory specified by \code{output_dir}
}
\description{
Analyze outliers in results file for all parameters
}
\details{
This function is a wrapper to \code{\link{anlzMWRoutlier}} to create plots for all parameters with appropriate data in the water quality monitoring results
}
\examples{
# results data path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data
accdat <- readMWRacc(accpth)

\donttest{
# create word output
anlzMWRoutlierall(resdat, accdat, group = 'month', format = 'word', output_dir = tempdir())

# create png output
anlzMWRoutlierall(resdat, accdat, group = 'month', format = 'png', output_dir = tempdir())

# create zipped png output
anlzMWRoutlierall(resdat, accdat, group = 'month', format = 'zip', output_dir = tempdir())
}
}
