% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\docType{data}
\name{example_data}
\alias{example_data}
\title{Example Dataset: Psychological and Behavioral Responses}
\format{
A data frame with multiple rows and 17 variables:
\describe{
\item{id}{Unique participant identifier (integer).}
\item{Relax}{Self-reported relaxation level (integer scale).}
\item{Irritable}{Self-reported irritability level (integer scale).}
\item{Worry}{Level of worry experienced (integer scale).}
\item{Nervous}{Self-reported nervousness (integer scale).}
\item{Future}{Concerns about the future (integer scale).}
\item{Anhedonia}{Self-reported lack of enjoyment (integer scale).}
\item{Tired}{Level of tiredness (integer scale).}
\item{Hungry}{Self-reported hunger level (integer scale).}
\item{Alone}{Feeling of loneliness (integer scale).}
\item{Angry}{Level of anger experienced (integer scale).}
\item{Social_offline}{Offline social interactions (integer scale).}
\item{Social_online}{Online social interactions (integer scale).}
\item{Music}{Time spent listening to music (integer scale).}
\item{Procrastinate}{Self-reported procrastination (integer scale).}
\item{Outdoors}{Time spent outdoors (integer scale).}
\item{C19_occupied}{Engagement in activities during COVID-19 (integer scale).}
\item{C19_worry}{Level of worry related to COVID-19 (integer scale).}
\item{Home}{Time spent at home (integer scale).}
\item{day}{Day number of the study (integer).}
\item{beep}{Moment within the day when data was collected (integer).}
\item{conc}{Self-reported concentration level (integer scale).}
}
}
\source{
Reproducible figure for Nature Methods primer paper, Borsboom et al. 2021. This examples contains a \emph{subset} of variables
collected and modeled in our covid19 paper. This paper, with full data is available on https://journals.sagepub.com/doi/10.1177/21677026211017839.
Eiko Fried, March 14 2021
}
\usage{
example_data
}
\description{
This dataset contains self-reported psychological and behavioral responses from individuals.
}
\details{
This dataset was collected from a study examining psychological and behavioral
responses to various daily experiences. Each row represents a unique moment of self-reporting.
}
\examples{
data(example_data)
head(example_data)

}
\keyword{datasets}
