% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VManova.R
\name{VManova}
\alias{VManova}
\title{Various Multivariate Anova(VManova)}
\usage{
VManova(data,
        grp1.name,
        grp2.name,
        way = "one",
        method = "all",
        plot.scale = FALSE)
}
\arguments{
\item{data}{A numeric matrix or data frame. If data frames, group(class) column can be a factor or a string.}

\item{grp1.name}{The name of the first group (or class) column in the input data, specified as a \code{string}.}

\item{grp2.name}{The name of the second group (or class) column in the input data, specified as a \code{string}. Used to represent the second group(class) in a two-way MANOVA.}

\item{way}{The type of MANOVA to perform ("\code{one}" for one-way or "\code{two}" for two-way). (default = "\code{one}")}

\item{method}{The method for MANOVA analysis. "\code{Wilks}" represents Wilks' lambda, "\code{LH}" represents Lawley-Hotelling trace, "\code{Pillai}" represents Pillai-Bartlett trace, "\code{Roy}" represents Roy's largest root, and "\code{all}" represents all methods. (default is "\code{all}")}

\item{plot.scale}{If \code{TRUE}, the data will be scaled before calculating mean values and used in the plot. It has no direct effect on the MANOVA analysis itself. (default plot.scale = \code{FALSE})}
}
\value{
\item{Mean.val.plot}{Plot the mean value parallel coordinates, representing the two samples using the mean values for each variable.}
   \item{One.all}{Outputs the results of a one-way MANOVA test. It displays the degrees of freedom (Df1, Df2) of the F-distribution, statistics for Wilks, Lawley-Hotelling, Pillai, and Roy, the F-distribution test statistic, and the significance level in that order.}
   \item{Two.all}{Outputs the results of a two-way MANOVA test. It displays the degrees of freedom (Df1, Df2) of the F-distribution, statistics for Wilks, Lawley-Hotelling, Pillai, and Roy, the F-distribution test statistic, and the significance level in that order.}
}
\description{
Perform various types of multivariate analysis of variance (MANOVA) that satisfy tests of multivariate normality and homogeneity of covariance matrices.
}
\examples{
data(wine)

## one way
VManova(wine, grp1.name = "class", way = "one", method = "all", plot.scale = TRUE)

## two way
newwine <- wine
# (1: low, 2: medium, 3: high)
newwine$v4 <- ifelse(wine$v4 <= 17, 1,
                     ifelse(wine$v4 <= 22, 2, 3))
VManova(newwine, grp1.name = "class", grp2.name = "v4",
        way = "two", method = "all", plot.scale = TRUE)


}
\references{
Rencher, A. C., & Christensen, W. F. (2002). Methods of Multivariate Analysis. John Wiley & Sons, Inc., New York.
}
\seealso{
\code{\link{mardiatest} for multivariate normality (Includes outlier remove)}

\code{\link{PPCCtest} for multivariate normality}

\code{\link{SPCCtest} for multivariate normality}

\code{\link{boxMtest} for homogeneity of covariance matrices}
}
\keyword{manova}
