% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFM_core.R
\name{MFM_core}
\alias{MFM_core}
\title{Probability Core for Multi-state RDT with Multiple Failure Modes (MFM)}
\usage{
MFM_core(n, cvec, pivec)
}
\arguments{
\item{n}{RDT sample size}

\item{cvec}{Maximum allowable failures for each separate period}

\item{pivec}{Failure probability for each seperate period}
}
\value{
Core probability of passing the test given specific failure probabilities
}
\description{
Define the summed core function inside of the integration which gets the probability of passing the test given specific failure probabilities
under different failure modes (for Multi-state RDT, Multiple Failure Modes).
}
\examples{
#' #Example for two failure modes
pi1 <- pi_MCSim_beta(M = 1000, seed = 10, a = 1, b = 1)
pi2 <- pi_MCSim_beta(M = 1000, seed = 10, a = 2, b = 18)
MFM_core(n = 10, cvec = c(1, 1), pivec = c(pi1[1], pi2[1]));
#The function also works for more than two failure modes.
#However, the computation cost may increase.
#Example for three failure modes
MFM_core(n = 10, cvec = c(1, 1, 1), pivec = c(0.8, 0.9, 0.8));
}
\seealso{
\code{\link{MFM_consumerrisk}} for getting the consumer's risk;
\code{\link{MFM_Indicator}} for getting the binary indicator;
\code{\link{MFM_optimal_n}} for getting the optimal test sample size;

Other MSRDT for MFM functions: 
\code{\link{MFM_Indicator}()},
\code{\link{MFM_consumerrisk}()},
\code{\link{MFM_optimal_n}()}
}
\concept{MSRDT for MFM functions}
