% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moidecoder.R
\name{decoder_aminoacid}
\alias{decoder_aminoacid}
\title{Translates the standard ambiguity codes for nucleotides
(amino acid decoder)}
\usage{
decoder_aminoacid(
  y,
  c_l,
  r_w,
  aa_1,
  aa_2,
  let_3,
  amino_acid,
  aa_symbol,
  coding,
  rw_col,
  multsh
)
}
\arguments{
\item{y}{numeric vector; entries in a cell corresponding
to a specific sample and a specific marker.}

\item{c_l}{string; marker label.}

\item{r_w}{numeric; sample ID's row number in the excel
file.}

\item{aa_1}{string vector; vector of different amino
acids.}

\item{aa_2}{string vector; vector of different codons.}

\item{let_3}{string vector; vector of amino acids in 3
letter designation.}

\item{amino_acid}{string vector; vector of amino acids in
full name.}

\item{aa_symbol}{string vector; vector of amino acids in
one letter designation.}

\item{coding}{string; coding class of the molecular
marker.}

\item{rw_col}{string vector; variable used to switch
between row and column in case of transposed data.
Namely, \code{c("rows ", "row ", "column ", "columns
")}.}

\item{multsh}{string; reports warnings for multiple
worksheet datasets.}
}
\value{
a list of two elements: 1) a vector of 3-letter
  designation of amino acids on a marker corresponding to
  a sample in pre-specified coding class. 2) an identifier
  whose value is 1 if a warning takes place.
}
\description{
Translates the standard ambiguity codes for
  nucleotides in amino acid forms from a pre-specified
  coding class to 3-letter designation of amino acids.
}
\seealso{
For further details see: \code{\link{moimport}},
  \code{\link{moi_marker}} and
  \code{\link{corrector_string}}. See also the
  vignette 'StandardAmbiguityCodes'.
}
\keyword{internal}
