% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survint.R
\name{survint_C}
\alias{survint_C}
\title{Survival Integral}
\usage{
survint_C(
  pred = c("lambda", "gamma", "long", "fpc_re"),
  pre_fac,
  pre_vec = NULL,
  omega,
  int_fac = NULL,
  int_vec = NULL,
  weights,
  survtime
)
}
\arguments{
\item{pred}{String to define for which predictor the survival integral is
calculated.}

\item{pre_fac}{Vector serving as factor before the survival integral.
Corresponds to the gamma predictor.}

\item{pre_vec}{Matrix serving as row vectors before the survival integral.
Only needed if pred = "gamma".}

\item{omega}{Vector serving as additive predictor placeholder within the
survival integral. Present for all pred.}

\item{int_fac}{Vector serving as factor within the survival integral. Only
needed for the longitudinal predictors.}

\item{int_vec}{Matrix serving as row vectors within the survival integral.
NULL only if pred = "gamma".}

\item{weights}{Vector containing the Gaussian integration weights.}

\item{survtime}{Vector containing the survival times for weighting of the
integral.}
}
\description{
This function is a wrapper function for calculating the survival integral in
C needed in the calculation of the score vector and Hessian.
}
\details{
The survival integral has a similar structure for the different model
predictors. It is always a sum over all individuals, followed by the
multiplication with a pre-integral factor (pre_fac). For the gamma predictor
a pre-integral vector is next. Then, the integral itself consists of a
weighted sum (weights) of gauss-quadrature integration points weighted by
the survival time of the individuals (survtime). Inside the integral, the
current additive predictor (omega) is multiplied with an in-integral vector
(int_vec), except for predictor gamma. All longitudinal predictors
addtitionally include an in-integration factor (int_fac).

The difference between predictors "long" and "fpc_re" is that the latter
makes efficient use of the block structure of the design matrix for
unconstrained functional principal component random effects. The outputs
also differ as the Hessian for "fpc_re" is a diagonal matrix, so only the
diagonal elements are returned.
}
