% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfpca_sim.R
\name{MFPCA_cov}
\alias{MFPCA_cov}
\title{Function to calculate the multivariate FPCA for a given covariance matrix and
univariate basis functions}
\usage{
MFPCA_cov(cov, basis_funs, scores = NULL, weights = NULL)
}
\arguments{
\item{cov}{Covariance matrix of the basis functions coefficients.}

\item{basis_funs}{List with basis functions on each dimension. The basis
functions are funData objects}

\item{scores}{Matrix (n rows, B columns) containing the basis functions
coefficients. Defaults to NULL which does not calculate the multivariate
scores.}

\item{weights}{Vector of weights, defaults to 1 for each element}
}
\value{
List mimicking an \code{MFPCAfit} object containing the following
  components:
  \describe{
   \item{values}{A vector of eigenvalues.}
   \item{functions}{A \code{multiFunData} object containing the multivariate
     functional principal components.}
   \item{scores}{A matrix containing the scores (if applicable).}
   \item{vectors}{A matrix representing the eigenvectors associated with the
     combined univaraite score vectors.}
   \item{normFactors}{The normalizing factors used for calculating the
     multivariate eigenfunctions and scores.}
}
}
\description{
Function to calculate the multivariate FPCA for a given covariance matrix and
univariate basis functions
}
\examples{
library(funData)
# Covariance matrix for the data generation in simulation scenario I
auto <- matrix(c(0.08, -0.07, -0.07, 0.9), ncol = 2)
cross <- matrix(rep(0.03, 4), ncol = 2)
cor <- matrix(c(0, 1, 0.75, 0.5, 0, 0,
                1, 0, 1, 0.75, 0.5, 0,
                0.75, 1, 0, 1, 0.75, 0.5,
                0.5, 0.75, 1, 0, 1, 0.75,
                0, 0.5, 0.75, 1, 0, 1,
                0, 0, 0.5, 0.75, 1, 0),
               ncol = 6)
cov <- kronecker(cor, cross) + kronecker(diag(c(1, 1.2, 1.4, 1.6, 1.8, 2)),
                                         auto)
# Basis functions on each dimension
seq1 <- seq(0, 1, by = 0.01)
b_funs <- rep(list(funData(argvals = seq1,
              X = matrix(c(rep(1, length(seq1)), seq1),
              byrow = TRUE, ncol = length(seq1)))), 6)
# Prepare objects for the model on different data sets
mfpca_tru <- MFPCA_cov(cov = cov, basis_funs = b_funs)
}
