% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.miive.R
\name{summary.miive}
\alias{summary.miive}
\title{Summary information for a MIIV estimation object}
\usage{
\method{summary}{miive}(object, eq.info = FALSE, restrict.tests = FALSE, rsquare = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{miive}}

\item{eq.info}{A logical indicating whether equation-specific 
information should be printed. Useful in models with 
large numbers of variables.}

\item{restrict.tests}{A logical indicating whether two 
test statistics for a large-sample wald test of 
linaer hypotheses imposed on the MIIV-2SLS coefficient 
matrix should be provided. The first statistic is 
an approximate F and the second is Chi-square. 
Assumptions and additional details for each test 
are given by Greene (2000, p. 346-347) and Henningsen 
and Hamman (2007).}

\item{rsquare}{A logical indicating whether R-square values for
endogeneous variables are included in the output. Only
available when \code{var.cov} is \code{TRUE}.}

\item{...}{Optional arguments to summary, not used by user.}
}
\description{
Summary information for a MIIV estimation object
}
\references{
Greene, W. H. (2000). Econometric analysis. Upper Saddle River, N.J: 
Prentice Hall.

Henningsen, A., and Hamann, J.D. (2007). systemfit: A Package for 
Estimating Systems of Simultaneous Equations in R. Journal of Statistical 
Software 23(4), 1-40.
}
