% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network-Migration.R
\name{oneDay_Migration_Stochastic_Network}
\alias{oneDay_Migration_Stochastic_Network}
\title{Stochastic Inter-Patch Migration}
\usage{
oneDay_Migration_Stochastic_Network()
}
\description{
Stochastic model of interpatch migration from each patch.
\code{popFemale}/\code{popMale} is retrieved from each patch using
\code{\link{get_femalePop_Patch}}/\code{\link{get_malePop_Patch}}. Migration
location is determined from the supplied matrices, \code{private$migrationFemale}
or \code{private$migrationMale}. Migration is modeled as a Multinomial
process parameterized by migration location probabilities corresponding to each
patch . Movement is sampled from \code{\link[stats]{rmultinom}}. \cr
Batch migration begins as a \code{\link[stats]{rbinom}} sampled from
\code{private$migrationBatch$batchProbs}.If there is batch migration, the
location of migration is sampled uniformly (see \code{\link[base]{sample}}),
parameterized by \code{private$migrationBatch$moveProbs}. The amount of each sex
that migrations is sampled from \code{\link[stats]{rbinom}}, parameterized by
\code{private$migrationBatch$sexProbs}.
}
\details{
This function handles outbound and inbound migration. See \code{\link{MGDrivE-Model}},
'Migration' section for more details on how inter-patch migration is handled.
}
\keyword{internal}
