% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_MFO_databases}
\alias{read_MFO_databases}
\title{Read databases for MFO package}
\usage{
read_MFO_databases(
  from = c("folder", "files"),
  path,
  db_basal_name,
  db_MFO_name,
  db_graded_name,
  col_name_VO2,
  col_name_VCO2,
  col_name_RER,
  col_name_HR,
  remove_rows = NULL
)
}
\arguments{
\item{from}{select either from folder or files}

\item{path}{path to the  the databases}

\item{db_basal_name}{name of the database with the basal metabolic rate test}

\item{db_MFO_name}{name of the database of MFO test}

\item{db_graded_name}{name of the database of the graded exercise test}

\item{col_name_VO2}{name given to the variable VO2 in the databases. Must be the same for all databases. Default set to "VO2"}

\item{col_name_VCO2}{name given to the variable VCO2 in the databases. Must be the same for all databases. Default set to "VCO2"}

\item{col_name_RER}{name given to the variable RER in the databases. Must be the same for all databases. Default set to "RER"}

\item{col_name_HR}{name given to the variable HR in the databases. Must be the same for all databases. Default set to "HR"}

\item{remove_rows}{An integer (or a vector of integers) representing the position of the rows to delete}
}
\value{
{Returns 3 databases:
\itemize{
\item participant_db_basal: database with basal metabolism.
\item participant_db_MFO: database with MFO test.
\item participant_db_graded: graded exercise test.
}}
}
\description{
Read databases for MFO package
}
