% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ME.fcRegression_MEM.R
\name{ME.fcRegression_MEM}
\alias{ME.fcRegression_MEM}
\title{Use UP_MEM or MP_MEM substitution to apply
(generalized) linear regression with one functional covariate with measurement error.}
\usage{
ME.fcRegression_MEM(
  data.Y,
  data.W,
  data.Z,
  method = c("UP_MEM", "MP_MEM", "average"),
  t_interval = c(0, 1),
  t_points = NULL,
  d = 3,
  family.W = c("gaussian", "poisson"),
  family.Y = "gaussian",
  formula.Z,
  basis.type = c("Fourier", "Bspline"),
  basis.order = NULL,
  bs_degree = 3,
  smooth = FALSE,
  silent = TRUE
)
}
\arguments{
\item{data.Y}{Response variable, can be an atomic vector, a one-column matrix or data frame,
recommended form is a one-column data frame with column name.}

\item{data.W}{A 3-dimensional array, represents \eqn{W}, the measurement of \eqn{X}.
Each row represents a subject.
Each column represent a measurement (time) point.
Each layer represents an observation.}

\item{data.Z}{Scalar covariate(s), can be not input or \code{NULL} (when there's no scalar covariate),
an atomic vector (when only one scalar covariate), a matrix or data frame,
recommended form is a data frame with column name(s).}

\item{method}{The method to construct the substitution \eqn{X}.
Available options: 'UP_MEM', 'MP_MEM', 'average'.}

\item{t_interval}{A 2-element vector, represents an interval,
means the domain of the functional covariate. Default is c(0,1), represent interval \eqn{[0,1]}.}

\item{t_points}{Sequence of the measurement (time) points, default is \code{NULL}.}

\item{d}{The number of time points involved for MP_MEM (default and miniumn is 3).}

\item{family.W}{Distribution of \eqn{W} given \eqn{X},  Available options: "gaussian","poisson".}

\item{family.Y}{A description of the error distribution
and link function to be used in the model, see \code{\link[stats]{family}}.}

\item{formula.Z}{A formula without the response variable,
contains only scalar covariate(s), use the format of lme4 package if random effects exist.
e.g. ~ Z_1 + (1|Z_2).
If not assigned, include all scalar covariates and intercept term as fixed effects.}

\item{basis.type}{Type of function basis.
Can only be assigned as one type even if there is more than one functional covariates.
Available options: 'Fourier' or 'Bspline',
represent Fourier basis and b-spline basis respectively.
For the detailed form for Fourier and b-splines basis,
see \code{\link{fourier_basis_expansion}} and \code{\link{bspline_basis_expansion}}.}

\item{basis.order}{Indicate number of the function basis.
When using Fourier basis \eqn{\frac{1}{2},\sin k t, \cos k t, k = 1,\dots,K},
basis.order is the number \eqn{K}.
When using b-splines basis \eqn{\{B_{i,p}(x)\}_{i=-p}^{k}}, basis.order is the number of splines,
equal to \eqn{k+p+1}. (same as arguement \code{df} in \code{\link[splines]{bs}}.)
May set a individual number for each functional covariate.
When the element of this argument is less than the number of functional covariates, it will be used recursively.}

\item{bs_degree}{Degree of the piecewise polynomials if use b-splines basis, default is 3.
See \code{degree} in \code{\link[splines]{bs}}.}

\item{smooth}{Whether to smooth the substitution of \eqn{X}. Default is \code{FALSE}.}

\item{silent}{Whether not to show the state of the running of the function. Default is \code{TRUE}.}
}
\value{
Returns a \code{fcRegression} object. See \code{\link{fcRegression}}.
}
\description{
The Mixed-effect model (MEM) approach is a two-stage-based method that employs functional mixed-effects models.
It allows us to delve into the nonlinear measurement error model,
where the relationship between the true and observed measurements is not constrained to be linear,
and the distribution assumption on the observed measurement is relaxed to encompass
the exponential family rather than being limited to the Gaussian distribution.
The MEM approach employs point-wise (UP_MEM) and multi-point-wise (MP_MEM) estimation
procedures to avoid potential computational complexities caused by analyses of
multi-level functional data and computations of potentially intractable and complex integrals.
}
\examples{
data(MECfda.data.sim.0.1)
res = ME.fcRegression_MEM(data.Y = MECfda.data.sim.0.1$Y,
                          data.W = MECfda.data.sim.0.1$W,
                          data.Z = MECfda.data.sim.0.1$Z,
                          method = 'UP_MEM',
                          family.W = "gaussian",
                          basis.type = 'Bspline')

}
\references{
Luan, Yuanyuan, et al. "Scalable regression calibration approaches to
correcting measurement error in multi-level generalized functional linear regression models
with heteroscedastic measurement errors." arXiv preprint arXiv:2305.12624 (2023).
}
