% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cure.R
\name{plotCure}
\alias{plotCure}
\title{Plot Cure Probability: A Comparison of Nonparametric and Parametric Estimation}
\usage{
plotCure(
  x,
  time,
  delta,
  main.title = NULL,
  title.x = NULL,
  model = "logit",
  theta = NULL,
  legend.pos = "bottom",
  density = TRUE,
  hsmooth = 10,
  npoints = 100
)
}
\arguments{
\item{x}{A numeric vector containing the covariate values.}

\item{time}{A numeric vector representing the observed survival times.}

\item{delta}{A binary vector indicating the event status (1 = event, 0 = censored).}

\item{main.title}{Character string for the main title of the plot. If \code{NULL}, a default is used.}

\item{title.x}{Character string for the x-axis label. If \code{NULL}, a default is used.}

\item{model}{A character string indicating the assumed model. Options include \code{"logit"}, \code{"probit"}, and \code{"cloglog"}. Defaults to \code{"logit"}.}

\item{theta}{A numeric vector of length 2, specifying the coefficients for the logistic model to generate the parametric estimate.}

\item{legend.pos}{A character string indicating the position of the legend. Options include \code{"bottom"}, \code{"top"}, \code{"left"}, \code{"right"}, \code{"none"}, etc.}

\item{density}{Logical; if \code{TRUE}, adds a secondary y-axis with the covariate density curve.}

\item{hsmooth}{Numeric. Smoothing bandwidth parameter (h) for the cure probability estimator.}

\item{npoints}{Integer. Number of points at which the estimator is evaluated over the covariate range.}
}
\value{
A ggplot object representing the cure probability plot.
}
\description{
This function generates a plot comparing nonparametric and parametric estimations of cure probability in a univariate setting.
The nonparametric estimate is displayed with 95\% confidence bands, while the parametric estimate is based on a logit, probit or
complementary log-log link.
An optional covariate density curve can be added as a secondary axis.
}
\details{
The function estimates the cure probability nonparametrically using the \code{\link[npcure:probcure]{probcure}} function
and overlays it with a parametric estimate obtained from a logistic regression model.
Confidence intervals (95\%) are included for the nonparametric estimate. Optionally,
the density of the covariate can be shown as a shaded area with a secondary y-axis.
}
\seealso{
\link[npcure:probcure]{probcure}
}
