% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchored_maic.R
\name{anchored_maic}
\alias{anchored_maic}
\title{Conduct Anchored Matching-Adjusted Indirect Comparison (MAIC).}
\arguments{
\item{ipds_wts}{A data frame containing individual patient data from the
intervention study, with a column containing the estimated weights (derived
using \code{\link{estimate_weights}}).}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \code{ipds_wts}, e.g., intervention.arm = TRT. The default is \code{TRT}.}

\item{agds_eff}{A data frame containing aggregate efficacy results from the
comparator study.}

\item{comparator}{The name of the study column in the data frame specified
by \code{agds_eff}, e.g., \code{comparator = STUDY}. The default is \code{STUDY}.}

\item{comparator.study}{A character specifying the comparator study, which
must be quoted and cannot be empty (e.g., \code{comparator.study = "Study XX-1"}).
This is the value of the study column in \code{agds_eff} set by the \code{comparator}
parameter.}

\item{ipds.param.var}{The name of the column that specifies only a subset
of the \code{ipds_wts} to be used.}

\item{ipds.param}{A character specifying the subset of the rows to be used.
This is the value of the column set by the \code{ipds.param.var}.}

\item{agds.param.var}{The name of the column that specifies only a specific
result of the \code{agds_eff} to be used.}

\item{agds.param}{A character specifying the subset of the rows to be used.
This is the value of the column set by the \code{agds.param.var}.}

\item{agds.estimate}{The column name of the point estimate of the effect
size.}

\item{agds.ci.lower}{The column name for the lower confidence limit of the
point estimate of the effect size.}

\item{agds.ci.upper}{The column name for the upper confidence limit of the
point estimate of the effect size.}

\item{time}{The name of the survival or follow-up time column in the
\code{ipds_wts}.}

\item{status}{The status indicator, normally 0 = event, 1 = censored. Can be
reset using the \code{event} parameter.}

\item{event}{A numeric value that represents the survival status, 0 = event,
1 = censored.}

\item{response}{The name of the response status column in the \code{ipds_wts}.}

\item{stralist}{A string specifying the stratification factors in a
stratified analysis, e.g., \code{stralist = "BPDL1, CNSBRAIN, AGEGR"}.}

\item{dtype}{Two options are available: "HR" and "OR". The default is "HR".}

\item{wt.col}{The name of the estimated weights column in the data frame
specified by \code{ipds_wts}. The default is \code{wt}.}

\item{CIw}{The numeric value specifying the width of the confidence
interval, with a default of 0.95.}

\item{digits}{Specify the number of decimal places for the output results.}
}
\value{
A data frame containing the anchored matching-adjusted indirect
comparison results.
}
\description{
The endpoint of interest is either time-to-event (e.g., overall survival)
or binary (e.g., objective tumor response). The methods described in this
documentation are based on those originally outlined by Signorovitch et al.,
2012, and further detailed in the National Institute for Health and Care
Excellence (NICE) Decision Support Unit (DSU) Technical Support Document
(TSD) 18.
}
\examples{
\donttest{
results1 <- anchored_maic(
  ipds_wts = pts, intervention.arm = TRT,
  agds_eff = AgD_eff, comparator = STUDY,
  comparator.study = "Study XX-1",
  ipds.param.var = PARAMCD, ipds.param = "OS",
  agds.param.var = PARAM, agds.param = "OS",
  agds.estimate = EST, agds.ci.lower = CIL, agds.ci.upper = CIU,
  time = AVAL, status = CNSR, event = 0,
  stralist = "BPDL1, CNSBRAIN, AGEGR", dtype = "HR",
  wt.col = wt, CIw = 0.95, digits = 2)

results1

results2 <- anchored_maic(
  ipds_wts = pts, intervention.arm = TRT,
  agds_eff = AgD_eff, comparator = STUDY,
  comparator.study = "Study XX-1",
  agds.param.var = PARAM, agds.param = "ORR",
  agds.estimate = EST, agds.ci.lower = CIL, agds.ci.upper = CIU,
  response = RESP,
  stralist = "BPDL1, CNSBRAIN, AGEGR", dtype = "OR",
  wt.col = wt, CIw = 0.95, digits = 2)

results2
}

}
