% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fastas.R
\name{create_fastas}
\alias{create_fastas}
\title{Table To FASTA}
\usage{
create_fastas(
  data_file = NULL,
  input_file = NULL,
  output_folder = NULL,
  no_marker = FALSE,
  no_taxa = FALSE,
  no_seq = FALSE,
  name_issue = FALSE,
  taxa_digits = FALSE,
  taxa_punct = FALSE
)
}
\arguments{
\item{data_file}{NULL prompts the user to indicate the location of the data file in the format of the auto_seq_download output, anything other than NULL then the string supplied will be used for the location; default NULL}

\item{input_file}{NULL prompts the user to indicate the location of the input file used to select through point and click prompts, anything other than NULL then the string supplied will be used for the location; default NULL}

\item{output_folder}{NULL prompts the user to indicate the location of the output file through point and click prompts, anything other than NULL then the string supplied will be used for the location; default NULL}

\item{no_marker}{If set to TRUE then will include records filtered out due to no marker data. Default is FALSE to not include records with no marker data.}

\item{no_taxa}{If set to TRUE then will include records filtered out due to no taxa data. Default is FALSE to not include records with no taxa data.}

\item{no_seq}{If set to TRUE then will include records filtered out due to no sequence data. Default is FALSE to not include records with no sequence data.}

\item{name_issue}{If set to TRUE then will include records filtered out due to genus and species names with more than two terms. Default is FALSE to not include records with taxonomic naming issues.}

\item{taxa_digits}{If set to TRUE then will include records filtered out due to genus or species names containing digits. Default is FALSE to not include records with digits in the taxonomic naming.}

\item{taxa_punct}{If set to TRUE then will include records filtered out due to the presence of punctuation in the genus or species names. Default is FALSE to not include records with punctuation in the taxonomic naming.}
}
\value{
This script outputs a fasta file of sequences for each column in the submitted parameters file. These files are named with the genera of interest and the first marker name in the column of the parameters file.
These files are located in the folder where the Total_tables.txt file is located.
}
\description{
Using the output table from the download script and the user built genus-marker name parameter file to take the downloaded data and place them into fasta files.
}
\details{
Input: File with list of genera with the molecular markers names below the taxa. The information to create this parameters file can be obtained from A_Summary.txt file from the download script results.
For further details please see the documentation.
}
\examples{
\dontrun{
create_fastas()
create_fastas(no_marker = TRUE, no_taxa = TRUE)
create_fastas(no_seq  = TRUE, name_issue = TRUE)
}

}
\references{
<https://github.com/rgyoung6/MACER>
Young RG, Gill R, Gillis D, Hanner RH (2021) Molecular Acquisition, Cleaning and Evaluation in R (MACER) - A tool to assemble molecular marker datasets from BOLD and GenBank. Biodiversity Data Journal 9: e71378. <https://doi.org/10.3897/BDJ.9.e71378>
}
\seealso{
create_fastas()
align_to_ref()
barcode_clean()
}
\author{
Rekkab Singh Gill
}
