% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateY.R
\name{simulateY}
\alias{simulateY}
\title{Generate the simulated dataset with specified parameters}
\usage{
simulateY(nclust = 4, n_byClust = c(10,20,5,25), J=1000, prop = 0.01,
noise = 0.1,flavor =c("normal", "beta", "binary"),
params = list(c(mean = 1,sd = 1)))
}
\arguments{
\item{nclust}{number of clusters}

\item{n_byClust}{number of samples per cluster}

\item{J}{number of features in each modality}

\item{prop}{proportion of cluster related features}

\item{noise}{percentage of noise adding to each modality}

\item{flavor}{a vector indicating the data type}

\item{params}{a list indicating the mean and standard derivation of the simulated data}
}
\value{
res, a list of length 2, where the first element is a list of simulated data, while the second element is a vector indicating the true label of each sample
}
\description{
Generate the simulated dataset with specified parameters
}
\examples{
temp_data <- simulateY(nclust = 4, n_byClust = c(10,20,5,25), J=1000,
prop = 0.01, noise = 0.1,flavor =c("normal", "beta", "binary"),
params = list(c(mean = 1,sd = 1)))
}
