% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolate_amplicon.R
\name{isolate_amplicon}
\alias{isolate_amplicon}
\title{Trim DNA Sequences to an Amplicon Region Using Forward and Reverse Primer Sequences}
\usage{
isolate_amplicon(sequences, forward_primer, reverse_primer)
}
\arguments{
\item{sequences}{A character vector of DNA sequences to trim to the amplicon region.}

\item{forward_primer}{A string specifying the forward primer sequence. Can contain ambiguous nucleotides.}

\item{reverse_primer}{A string specifying the reverse primer sequence. Can contain ambiguous nucletodies.}
}
\value{
A character vector of DNA sequences trimmed to the amplicon region. \code{NA}s are returned for DNA sequences which could not be trimmed, which occurs when either primer region is missing from the DNA sequence or when the forward primer region occurs after a region matching the reverse complement of the reverse primer.
}
\description{
Trims DNA sequences to an amplicon region using forward and reverse primer sequences. Ambiguous nucleotides in forward and reverse primers are supported.
}
\details{
For each DNA sequence, nucleotides matching and preceding the forward primer are removed, and nucleotides matching and following the reverse complement of the reverse primer are removed. The reverse complement of the reverse primer is internally derived from the reverse primer using the \code{\link[=reverse_complement]{reverse_complement}} function. Ambiguous nucleotides in primers (\emph{i.e.}, the forward and reverse primer arguments) are supported through the internal use of the \code{\link[=substitute_wildcards]{substitute_wildcards}} function on the forward primer and the reverse complement of the reverse primer, and primer regions in DNA sequences are located using regular expressions. Trimming will fail for DNA sequences which contain ambiguous nucleotides in their primer regions (\emph{e.g.}, Ns), resulting in \code{NA}s for those sequences.
}
\examples{
isolate_amplicon(sequences=c("ACACAATCGTGTTTATATTAACTTCAAGAGTGGGCATAGG",
                             "CGTGACAATCATGTTTGTGATTCGTACAAAAGTGCGTCCT"),
                 forward_primer="AATCRTGTTT",
                 reverse_primer="CSCACTHTTG")
}
