% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsd_del.R
\name{rsd_calculator}
\alias{rsd_calculator}
\title{Calculate Relative Standard Deviation (RSD)}
\usage{
rsd_calculator(
  data,
  start,
  end,
  threshold = 0.2,
  show.del = FALSE,
  del.zero = TRUE
)
}
\arguments{
\item{data}{The data frame containing abundance data.}

\item{start}{The starting column index of the QC data range.}

\item{end}{The ending column index of the QC data range.}

\item{threshold}{The threshold value for RSD. Default is 0.2.}

\item{show.del}{Logical value indicating whether to show the deleted data. Default is FALSE.}

\item{del.zero}{Logical value indicating whether to delete rows with all QC being zero . Default is TRUE.}
}
\value{
A data frame containing the calculated RSD values and the corresponding data.
}
\description{
This function calculates the relative standard deviation (RSD) based on the specified data range.
}
\examples{
qc_1=rnorm(n=5,mean=0.3,sd=0.2)
qc_2=rnorm(n=5,mean=0.3,sd=0.2)
qc_3=rnorm(n=5,mean=0.3,sd=0.2)
qc_4=rnorm(n=5,mean=0.3,sd=0.2)
qc_5=rnorm(n=5,mean=0.3,sd=0.2)
WT_1=rnorm(n=5,mean=0.3,sd=0.1)
WT_2=rnorm(n=5,mean=0.3,sd=0.1)
WT_3=rnorm(n=5,mean=0.3,sd=0.1)
KO_1=rnorm(n=5,mean=0.3,sd=0.1)
KO_2=rnorm(n=5,mean=0.3,sd=0.1)
KO_3=rnorm(n=5,mean=0.3,sd=0.1)
data=data.frame(qc_1,qc_2,qc_3,qc_4,qc_5,WT_1,WT_2,WT_3,KO_1,KO_2,KO_3)
rownames(data)=c("LPC(16:0)","PC(14:0/16:1)","PC(18:1/18:1)","PE(18:0/20:1)","PS(20:1/20:1)")
rsd_calculator(data,1,5,show.del = TRUE)
}
