% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Circular2Time.R
\name{Circular2Time}
\alias{Circular2Time}
\title{Convert circular time columns to hms}
\usage{
Circular2Time(
  dataset,
  cols = dplyr::where(circular::is.circular),
  silent = FALSE
)
}
\arguments{
\item{dataset}{A data.frame with \code{circular} columns representing time of day.}

\item{cols}{The column names to convert. Expects a \code{symbol}. The default will
convert all \code{circular} columns. If uncertain whether columns exist in the
dataset, use \code{\link[dplyr:reexports]{dplyr::any_of()}}.}

\item{silent}{Logical on whether no message shall be shown if input and
output are identical. Defaults to \code{FALSE} (i.e., a message is shown).}
}
\value{
The input dataset with converted circular columns as time (hms)
columns. With the default settings, if no circular column exists, input and
output will be identical.
}
\description{
Convert circular time columns to hms
}
\examples{
times <- lubridate::as_datetime("2023-01-01 10:00:00") + lubridate::hours(0:2)
times
circular_times <- Datetime2Time(tibble::tibble(Timestamp = times), circular = TRUE)
circular_times
Circular2Time(circular_times)

#if times are not circular, then an averaging can be problematic across midnight:
selected_times <- 
sample.data.environment |> 
sample_groups() |> 
dplyr::slice(c(40:43, 51838:51840))
selected_times

#a simple averaging will lead to a nonsensical value, e.g. if this should 
#calculate average sleep timing: ~10:00 in the morning
selected_times |> summarize_numeric()

#by converting it to a circular beforehand, averaging works as expected: 
#~3 minutes after midnight
selected_times |> 
summarize_numeric(Datetime2Time.circular = TRUE) |> 
Circular2Time()
}
