% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hipergeom.R
\name{plotHyper}
\alias{plotHyper}
\title{Probability Mass and/or Distribution Function Representations associated with a Hypergeometric Distribution}
\usage{
plotHyper(N, n, k, type = "b", col = "grey")
}
\arguments{
\item{N}{the population size.}

\item{n}{the number of draws.}

\item{k}{the number of success states in the population.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for probability mass function and distribution function representations together,
"d" for distribution function representation and "p" for probability mass function representation.}

\item{col}{a single colour associated with the probability mass function representation; default to "grey".}
}
\value{
A matrix containing the probability mass and the distribution function associated with each point
of the support of a Hypergeometric distribution with parameters \code{N}, \code{n} and \code{k}.
}
\description{
\code{plotHyper} represents the probability mass and/or the distribution function associated with a Hypergeometric
 distribution with parameters \code{N}, \code{n} and \code{k}.
}
\examples{
N=20;n=12;k=5
plotHyper(N,n,k,type="d")
plotHyper(N,n,k,type="p",col="pink")
plotHyper(N,n,k)
}
